package mezz.jei.api.gui.builder;

import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import java.util.Collection;
import java.util.List;

/**
 * Helper for building tooltips.
 *
 * @since 19.5.4
 */
public interface ITooltipBuilder {
	/**
	 * Add a {@link class_5348} line to this tooltip
	 * Note that {@link class_2561} is {@link class_5348}.
	 *
	 * @since 19.5.4
	 */
	void add(class_5348 component);

	/**
	 * Add multiple {@link class_5348} lines to this tooltip
	 * Note that {@link class_2561} is {@link class_5348}.
	 *
	 * @since 19.5.4
	 */
	void addAll(Collection<? extends class_5348> components);

	/**
	 * Add a {@link class_5632} line to this tooltip,
	 * to add images and other rich content.
	 *
	 * @implNote Make sure that {@link class_5684#method_32663(class_5632)}
	 * works for your {@link class_5632} on your platform (NeoForge, Fabric, Forge)
	 * or else it will crash.
	 *
	 * @since 19.5.4
	 */
	void add(class_5632 component);

	/**
	 * Add an ingredient that is associated with this tooltip.
	 * Most platforms use this ingredient information in tooltip events in
	 * order to add extra info to the tooltip.
	 *
	 * @since 19.5.4
	 */
	void setIngredient(ITypedIngredient<?> typedIngredient);

	/**
	 * Remove all the lines and ingredients from this tooltip.
	 *
	 * @since 19.16.4
	 */
	void clear();

	/**
	 * @deprecated this is only for legacy tooltip support and will be removed
	 */
	@Deprecated(since = "19.8.4", forRemoval = true)
	List<class_2561> toLegacyToComponents();

	/**
	 * @deprecated this is only for legacy tooltip support and will be removed
	 */
	@Deprecated(since = "19.8.4", forRemoval = true)
	void removeAll(List<class_2561> components);
}
