package mezz.jei.api.constants;

import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_8059;
import net.minecraft.class_8786;

/**
 * List of all the built-in {@link RecipeType}s that are added by JEI.
 *
 * @since 9.5.0
 */
public final class RecipeTypes {
	/**
	 * The crafting recipe type.
	 *
	 * Automatically includes all recipes in the {@link net.minecraft.class_1863}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3955>> CRAFTING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17545);

	/**
	 * The stonecutting recipe type.
	 *
	 * Automatically includes every {@link class_3975}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3975>> STONECUTTING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17641);

	/**
	 * The smelting recipe type.
	 *
	 * Automatically includes every {@link class_3861}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3861>> SMELTING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17546);

	/**
	 * The smoking recipe type.
	 *
	 * Automatically includes every {@link class_3862}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3862>> SMOKING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17548);

	/**
	 * The blasting recipe type.
	 *
	 * Automatically includes every {@link class_3859}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3859>> BLASTING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17547);

	/**
	 * The campfire cooking recipe type.
	 *
	 * Automatically includes every {@link class_3920}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_3920>> CAMPFIRE_COOKING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_17549);

	/**
	 * The fueling recipe type.
	 *
	 * JEI automatically creates a fuel recipe for anything that has a burn time.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiFuelingRecipe> FUELING =
		RecipeType.create(ModIds.MINECRAFT_ID, "fuel", IJeiFuelingRecipe.class);

	/**
	 * The brewing recipe type.
	 *
	 * JEI automatically tries to generate all potion variations from the basic ingredients,
	 * and also automatically adds modded potions from the Forge BrewingRecipeRegistry
	 *
	 * @see IVanillaRecipeFactory#createBrewingRecipe to create new brewing recipes in JEI.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiBrewingRecipe> BREWING =
		RecipeType.create(ModIds.MINECRAFT_ID, "brewing", IJeiBrewingRecipe.class);

	/**
	 * The anvil recipe type.
	 *
	 * @see IVanillaRecipeFactory#createAnvilRecipe to create new anvil recipes in JEI.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiAnvilRecipe> ANVIL =
		RecipeType.create(ModIds.MINECRAFT_ID, "anvil", IJeiAnvilRecipe.class);

	/**
	 * The grindstone recipe type.
	 *
	 * @see IVanillaRecipeFactory#createGrindstoneRecipe to create new grindstone recipes in JEI.
	 *
	 * @since 19.22.1
	 */
	public static final RecipeType<IJeiGrindstoneRecipe> GRINDSTONE =
			RecipeType.create(ModIds.MINECRAFT_ID, "grindstone", IJeiGrindstoneRecipe.class);

	/**
	 * The smithing recipe type.
	 * Automatically includes every
	 * {@link net.minecraft.class_8062}
	 * {@link net.minecraft.class_8060}
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_8786<class_8059>> SMITHING =
		RecipeType.createFromVanilla(net.minecraft.class_3956.field_25388);

	/**
	 * The composting recipe type.
	 * Automatically includes every item added to {@link class_3962#field_17566}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiCompostingRecipe> COMPOSTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "compostable", IJeiCompostingRecipe.class);

	/**
	 * The JEI info recipe type.
	 *
	 * @see IRecipeRegistration#addIngredientInfo to create this type of recipe.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiIngredientInfoRecipe> INFORMATION =
		RecipeType.create(ModIds.JEI_ID, "information", IJeiIngredientInfoRecipe.class);

	private RecipeTypes() {}
}
