package mezz.jei.api.recipe.vanilla;

import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import net.minecraft.class_1856;
import net.minecraft.class_2447;
import net.minecraft.class_3955;

/**
 * Builds a serializable ShapedRecipe that isn't registered with the vanilla game.
 * Useful for generating crafting recipes from {@link IRecipeManagerPlugin}.
 *
 * @since 19.15.0
 */
public interface IJeiShapedRecipeBuilder {

	/**
	 * Indicate which ingredient should be used for the given character in the recipe pattern.
	 *
	 * @see class_2447#method_10433
	 * @since 19.15.0
	 */
	IJeiShapedRecipeBuilder define(Character character, class_1856 ingredient);

	/**
	 * Set a row of the pattern for this recipe.
	 *
	 * @see class_2447#method_10439
	 * @since 19.15.0
	 */
	IJeiShapedRecipeBuilder pattern(String patternRow);

	/**
	 * Optionally set the group name of this recipe.
	 *
	 * @see class_2447#method_10435(String)
	 * @since 19.15.0
	 */
	IJeiShapedRecipeBuilder group(String group);

	/**
	 * Create an unregistered shaped recipe based on the ingredients and pattern.
	 *
	 * @since 19.15.0
	 */
	class_3955 build();
}
