/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class IngredientHelper
implements IPlatformIngredientHelper {
    @Override
    public Ingredient createShulkerDyeIngredient(DyeColor color) {
        Stream<Ingredient.TagValue> colorIngredientStream;
        DyeItem dye = DyeItem.byColor((DyeColor)color);
        TagKey colorTag = color.getTag();
        Ingredient.TagValue colorList = new Ingredient.TagValue(colorTag);
        Registry itemRegistry = RegistryUtil.getRegistry(Registries.ITEM);
        Iterable coloredItems = itemRegistry.getTagOrEmpty(colorTag);
        boolean contains = StreamSupport.stream(coloredItems.spliterator(), false).anyMatch(h -> h.value() == dye);
        if (!contains) {
            ItemStack dyeStack = new ItemStack((ItemLike)dye);
            Ingredient.ItemValue dyeList = new Ingredient.ItemValue(dyeStack);
            colorIngredientStream = Stream.of(dyeList, colorList);
        } else {
            colorIngredientStream = Stream.of(colorList);
        }
        return Ingredient.fromValues(colorIngredientStream);
    }

    @Override
    public Ingredient createNbtIngredient(ItemStack stack, IStackHelper stackHelper) {
        return DataComponentIngredient.of((boolean)false, (ItemStack)stack);
    }

    @Override
    public List<Ingredient> getPotionContainers(PotionBrewing potionBrewing) {
        return potionBrewing.containers;
    }

    @Override
    public Stream<Ingredient> getPotionIngredients(PotionBrewing potionBrewing) {
        return Stream.concat(potionBrewing.containerMixes.stream(), potionBrewing.potionMixes.stream()).map(PotionBrewing.Mix::ingredient);
    }
}

