/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge;

import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.gui.config.InternalKeyMappings;
import mezz.jei.library.startup.JeiStarter;
import mezz.jei.library.startup.StartData;
import mezz.jei.neoforge.events.PermanentEventSubscriptions;
import mezz.jei.neoforge.network.NetworkHandler;
import mezz.jei.neoforge.plugins.neoforge.NeoForgeGuiPlugin;
import mezz.jei.neoforge.startup.ForgePluginFinder;
import mezz.jei.neoforge.startup.StartEventObserver;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

public class JustEnoughItemsClient {
    private final PermanentEventSubscriptions subscriptions;

    public JustEnoughItemsClient(NetworkHandler networkHandler, PermanentEventSubscriptions subscriptions) {
        this.subscriptions = subscriptions;
        InternalKeyMappings keyMappings = JustEnoughItemsClient.createKeyMappings(subscriptions);
        Internal.setKeyMappings(keyMappings);
        IConnectionToServer serverConnection = networkHandler.getConnectionToServer();
        List<IModPlugin> plugins = ForgePluginFinder.getModPlugins();
        StartData startData = new StartData(plugins, serverConnection, keyMappings);
        JeiStarter jeiStarter = new JeiStarter(startData);
        StartEventObserver startEventObserver = new StartEventObserver(jeiStarter::start, jeiStarter::stop);
        startEventObserver.register(subscriptions);
    }

    public void register() {
        this.subscriptions.register(RegisterClientReloadListenersEvent.class, this::onRegisterReloadListenerEvent);
    }

    private void onRegisterReloadListenerEvent(RegisterClientReloadListenersEvent event) {
        Textures textures = Internal.getTextures();
        event.registerReloadListener((PreparableReloadListener)textures.getSpriteUploader());
        event.registerReloadListener((PreparableReloadListener)this.createReloadListener());
    }

    private ResourceManagerReloadListener createReloadListener() {
        return resourceManager -> NeoForgeGuiPlugin.getResourceReloadHandler().ifPresent(r -> r.onResourceManagerReload(resourceManager));
    }

    private static InternalKeyMappings createKeyMappings(PermanentEventSubscriptions subscriptions) {
        HashSet keysToRegister = new HashSet();
        subscriptions.register(RegisterKeyMappingsEvent.class, e -> keysToRegister.forEach(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0)));
        return new InternalKeyMappings(keysToRegister::add);
    }
}

