/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.ingredients.IngredientSet;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;

public class BrewingRecipeMakerCommon {
    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager, PotionBrewing potionBrewing) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        Registry potionRegistry = RegistryUtil.getRegistry(Registries.POTION);
        IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<ItemStack> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry, potionBrewing);
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IngredientSet potionReagents = ingredientHelper.getPotionIngredients(potionBrewing).flatMap(i -> Arrays.stream(i.getItems())).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(potionBrewing, recipeFactory, itemStackHelper, knownPotions, potionReagents, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static IngredientSet<ItemStack> getBaseKnownPotions(IIngredientManager ingredientManager, Registry<Potion> potionRegistry, PotionBrewing potionBrewing) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet potionContainers = ingredientHelper.getPotionContainers(potionBrewing).stream().flatMap(potionItem -> Arrays.stream(potionItem.getItems())).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        IngredientSet<ItemStack> knownPotions = new IngredientSet<ItemStack>(itemStackHelper, UidContext.Ingredient);
        knownPotions.addAll(potionContainers);
        potionRegistry.holders().forEach(potion -> {
            for (ItemStack potionContainer : potionContainers) {
                ItemStack result = PotionContents.createItemStack((Item)potionContainer.getItem(), (Holder)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<ItemStack> getNewPotions(PotionBrewing potionBrewing, IVanillaRecipeFactory recipeFactory, IIngredientHelper<ItemStack> itemStackHelper, Collection<ItemStack> knownPotions, Collection<ItemStack> potionReagents, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            String inputId = itemStackHelper.getUniqueId(potionInput, UidContext.Recipe);
            String inputPathId = ResourceLocationUtil.sanitizePath(inputId);
            for (ItemStack potionReagent : potionReagents) {
                String outputId;
                Optional potionOutputType;
                ItemStack potionOutput = BrewingRecipeMakerCommon.getOutput(potionBrewing, potionInput.copy(), potionReagent);
                if (potionOutput.isEmpty() || potionInput.getItem() instanceof PotionItem && potionOutput.getItem() instanceof PotionItem && (potionOutputType = ((PotionContents)potionOutput.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion()).isEmpty() || Objects.equals(inputId, outputId = itemStackHelper.getUniqueId(potionOutput, UidContext.Recipe))) continue;
                String outputModId = itemStackHelper.getResourceLocation(potionOutput).getNamespace();
                String uidPath = inputPathId + ".to." + ResourceLocationUtil.sanitizePath(outputId);
                IJeiBrewingRecipe recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.copy(), potionOutput, ResourceLocation.fromNamespaceAndPath((String)outputModId, (String)uidPath));
                if (recipes.contains(recipe)) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private static ItemStack getOutput(PotionBrewing potionBrewing, ItemStack potion, ItemStack itemStack) {
        ItemStack result = potionBrewing.mix(itemStack, potion);
        if (result != itemStack) {
            return result;
        }
        return ItemStack.EMPTY;
    }
}

