/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;

public class ErrorIngredientRenderer
implements IIngredientRenderer<ErrorIngredient> {
    private static final List<RenderType> RENDER_TYPES = List.of(RenderType.gui(), RenderType.glint(), RenderType.debugFilledBox(), RenderType.guiOverlay(), RenderType.guiGhostRecipeOverlay(), RenderType.guiTextHighlight());
    private final IIngredientHelper<ErrorIngredient> ingredientHelper;

    public ErrorIngredientRenderer(IIngredientHelper<ErrorIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    @Override
    public void render(GuiGraphics guiGraphics, ErrorIngredient ingredient) {
        Minecraft minecraft = Minecraft.getInstance();
        switch (ingredient.getCrashType()) {
            case RenderBreakVertexBufferCrash: {
                MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
                for (RenderType renderType : RENDER_TYPES) {
                    VertexConsumer buffer = bufferSource.getBuffer(renderType);
                    buffer.addVertex(0.0f, 0.0f, 0.0f).setColor(100);
                }
                throw new RuntimeException("intentional render crash for testing");
            }
            case TooltipCrash: {
                Font font = this.getFontRenderer(minecraft, ingredient);
                guiGraphics.drawString(font, "JEI", 0, 0, -65536, false);
                guiGraphics.drawString(font, "TEST", 0, 8, -65536, false);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    public List<Component> getTooltip(ErrorIngredient ingredient, TooltipFlag tooltipFlag) {
        if (ingredient.getCrashType() == ErrorIngredient.CrashType.TooltipCrash) {
            throw new RuntimeException("intentional tooltip crash for testing");
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String displayName = this.ingredientHelper.getDisplayName(ingredient);
        tooltip.add((Component)Component.literal((String)displayName));
        MutableComponent debugIngredient = Component.literal((String)"debug ingredient");
        tooltip.add((Component)debugIngredient.withStyle(ChatFormatting.GRAY));
        return tooltip;
    }
}

