/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.config.IModIdFormatConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public final class ModIdHelper
implements IModIdHelper {
    private final IModIdFormatConfig modIdFormattingConfig;
    private final IIngredientManager ingredientManager;
    private final ImmutableSetMultimap<String, String> modAliases;

    public ModIdHelper(IModIdFormatConfig modIdFormattingConfig, IIngredientManager ingredientManager, ImmutableSetMultimap<String, String> modAliases) {
        this.modIdFormattingConfig = modIdFormattingConfig;
        this.ingredientManager = ingredientManager;
        this.modAliases = modAliases;
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (DebugConfig.isDebugModeEnabled() && Minecraft.getInstance().options.advancedItemTooltips) {
            tooltip = ModIdHelper.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
        tooltipCopy.add((Component)Component.literal((String)modName));
        return tooltipCopy;
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> type = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.stripFormatting((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    private static <T> List<Component> addDebugInfo(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<Component>(tooltip);
        MutableComponent jeiDebug = Component.literal((String)"JEI Debug:");
        MutableComponent type = Component.literal((String)("type: " + ingredientHelper.getIngredientType().getUid()));
        MutableComponent subtypes = Component.literal((String)("has subtypes: " + (ingredientHelper.hasSubtypes(ingredient) ? "true" : "false")));
        MutableComponent uid = Component.literal((String)("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient)));
        MutableComponent info = Component.literal((String)("extra info: " + ingredientHelper.getErrorInfo(ingredient)));
        tooltip.add((Component)jeiDebug.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)type.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)subtypes.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)uid.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)info.withStyle(ChatFormatting.DARK_GRAY));
        return tooltip;
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    @Override
    public Set<String> getModAliases(String modId) {
        return this.modAliases.get((Object)modId);
    }

    @Override
    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

