/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.lookups;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.lookups.IFocusedRecipes;

public interface ILookupState {
    public List<IRecipeCategory<?>> getRecipeCategories();

    public boolean moveToRecipeCategory(IRecipeCategory<?> var1);

    public int getRecipesPerPage();

    public void setRecipesPerPage(int var1);

    public int getRecipeIndex();

    public IFocusGroup getFocuses();

    public IFocusedRecipes<?> getFocusedRecipes();

    public void nextRecipeCategory();

    public void previousRecipeCategory();

    public void goToFirstPage();

    public void nextPage();

    public void previousPage();

    public int pageCount();

    default public <T> List<T> getVisible(List<? extends T> recipes) {
        int firstRecipeIndex = this.getRecipeIndex() - this.getRecipeIndex() % this.getRecipesPerPage();
        int maxIndex = Math.min(recipes.size(), firstRecipeIndex + this.getRecipesPerPage());
        return IntStream.range(firstRecipeIndex, maxIndex).mapToObj(recipes::get).collect(Collectors.toList());
    }
}

