/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconToggleButton {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private AbstractContainerMenu parentContainer;
    @Nullable
    private Player player;

    public static RecipeTransferButton create(IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
        Rect2i layoutArea = recipeLayout.getRect();
        buttonArea.setX(buttonArea.getX() + layoutArea.getX());
        buttonArea.setY(buttonArea.getY() + layoutArea.getY());
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeTransfer();
        RecipeTransferButton transferButton = new RecipeTransferButton(icon, recipeLayout, onClose);
        transferButton.updateBounds(buttonArea);
        return transferButton;
    }

    private RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        super(icon, icon);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(@Nullable AbstractContainerMenu parentContainer, @Nullable Player player) {
        this.player = player;
        this.parentContainer = parentContainer;
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, this.recipeLayout, player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.button.active = true;
            this.button.visible = true;
        } else {
            this.button.active = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.button.visible = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            boolean maxTransfer = Screen.hasShiftDown();
            if (this.parentContainer != null && this.player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, this.parentContainer, this.recipeLayout, this.player, maxTransfer)) {
                this.onClose.run();
            }
        }
        return true;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        if (this.recipeTransferError == null) {
            MutableComponent tooltipTransfer = Component.translatable((String)"jei.tooltip.transfer");
            tooltip.add((Component)tooltipTransfer);
        } else {
            tooltip.addAll(this.recipeTransferError.getTooltip());
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return false;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.draw(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.recipeTransferError != null) {
            if (this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                guiGraphics.fill(RenderType.guiOverlay(), this.button.getX(), this.button.getY(), this.button.getX() + this.button.getWidth(), this.button.getY() + this.button.getHeight(), this.recipeTransferError.getButtonHighlightColor());
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                this.recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.getX(), recipeRect.getY());
            }
        }
    }

    public Optional<IRecipeTransferError> getRecipeTransferError() {
        return Optional.ofNullable(this.recipeTransferError);
    }
}

