/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RecipeLayoutWithButtons<R> {
    private final IRecipeLayoutDrawable<R> recipeLayout;
    private final RecipeTransferButton transferButton;
    private final RecipeBookmarkButton bookmarkButton;

    public RecipeLayoutWithButtons(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton, RecipeBookmarkButton bookmarkButton) {
        this.recipeLayout = recipeLayout;
        this.transferButton = transferButton;
        this.bookmarkButton = bookmarkButton;
    }

    public IRecipeLayoutDrawable<R> getRecipeLayout() {
        return this.recipeLayout;
    }

    public RecipeTransferButton getTransferButton() {
        return this.transferButton;
    }

    public RecipeBookmarkButton getBookmarkButton() {
        return this.bookmarkButton;
    }

    public int totalWidth() {
        int buttonRight;
        Rect2i buttonArea;
        Rect2i area = this.recipeLayout.getRect();
        Rect2i areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.getX() - areaWithBorder.getX();
        int rightAreaWidth = areaWithBorder.getWidth() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            buttonRight = buttonArea.getX() + buttonArea.getWidth();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        if (this.bookmarkButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
            buttonRight = buttonArea.getX() + buttonArea.getWidth();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler(new RecipeLayoutUserInputHandler<R>(this.recipeLayout), this.bookmarkButton.createInputHandler(), this.transferButton.createInputHandler());
    }

    private static class RecipeLayoutUserInputHandler<R>
    implements IUserInputHandler {
        private final IRecipeLayoutDrawable<R> recipeLayout;

        public RecipeLayoutUserInputHandler(IRecipeLayoutDrawable<R> recipeLayout) {
            this.recipeLayout = recipeLayout;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (!this.recipeLayout.isMouseOver(input.getMouseX(), input.getMouseY())) {
                return Optional.empty();
            }
            Rect2i recipeArea = this.recipeLayout.getRect();
            double recipeMouseX = input.getMouseX() - (double)recipeArea.getX();
            double recipeMouseY = input.getMouseY() - (double)recipeArea.getY();
            R recipe = this.recipeLayout.getRecipe();
            IRecipeCategory<R> recipeCategory = this.recipeLayout.getRecipeCategory();
            if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
                return Optional.of(this);
            }
            if (input.is(keyBindings.getCopyRecipeId()) && this.handleCopyRecipeId(this.recipeLayout)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
            R recipe;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            ResourceLocation registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
            if (registryName == null) {
                MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.displayClientMessage((Component)message, false);
                }
                return false;
            }
            String recipeId = registryName.toString();
            minecraft.keyboardHandler.setClipboard(recipeId);
            MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{Component.literal((String)recipeId)});
            if (player != null) {
                player.displayClientMessage((Component)message, false);
            }
            return true;
        }
    }
}

