/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.BookmarkTooltipFeature;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipHelper;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.bookmarks.IngredientsTooltipComponent;
import mezz.jei.gui.overlay.bookmarks.PreviewTooltipComponent;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.util.FocusUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkElement<R, I>
implements IElement<I> {
    private final RecipeBookmark<R, I> recipeBookmark;
    private final IDrawable icon;
    private final IClientConfig clientConfig;
    private final EnumMap<BookmarkTooltipFeature, ClientTooltipComponent> cache = new EnumMap(BookmarkTooltipFeature.class);
    @Nullable
    private Optional<IRecipeLayoutDrawable<R>> cachedLayoutDrawable;

    public RecipeBookmarkElement(RecipeBookmark<R, I> recipeBookmark, IDrawable icon) {
        this.recipeBookmark = recipeBookmark;
        this.icon = icon;
        this.clientConfig = Internal.getJeiClientConfigs().getClientConfig();
    }

    @Override
    public ITypedIngredient<I> getTypedIngredient() {
        return this.recipeBookmark.getRecipeOutput();
    }

    @Override
    public Optional<IBookmark> getBookmark() {
        return Optional.of(this.recipeBookmark);
    }

    @Override
    public void renderExtras(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(8.0f, 8.0f, 200.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.icon.draw(guiGraphics);
        poseStack.popPose();
    }

    @Override
    public boolean handleClick(UserInput input, IInternalKeyMappings keyBindings, IRecipesGui recipesGui, FocusUtil focusUtil) {
        boolean transferOnce = input.is(keyBindings.getTransferRecipeBookmark());
        boolean transferMax = input.is(keyBindings.getMaxTransferRecipeBookmark());
        if (transferOnce || transferMax) {
            Minecraft minecraft = Minecraft.getInstance();
            Screen screen = minecraft.screen;
            LocalPlayer player = minecraft.player;
            if (player != null && screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                IRecipeLayoutDrawable recipeLayout = this.getRecipeLayoutDrawable().orElse(null);
                if (recipeLayout == null) {
                    return false;
                }
                IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
                AbstractContainerMenu container = containerScreen.getMenu();
                if (input.isSimulate()) {
                    IRecipeTransferError recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, (Player)player).orElse(null);
                    return recipeTransferError == null || recipeTransferError.getType().allowsTransfer;
                }
                return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, (Player)player, transferMax);
            }
        }
        return false;
    }

    @Override
    public void show(IRecipesGui recipesGui, FocusUtil focusUtil, List<RecipeIngredientRole> roles) {
        IRecipeCategory<R> recipeCategory = this.recipeBookmark.getRecipeCategory();
        R recipe = this.recipeBookmark.getRecipe();
        ITypedIngredient<I> ingredient = this.getTypedIngredient();
        List<IFocus<?>> focuses = focusUtil.createFocuses(ingredient, List.of(RecipeIngredientRole.OUTPUT));
        recipesGui.showRecipes(recipeCategory, List.of(recipe), focuses);
    }

    @Override
    public List<ClientTooltipComponent> getTooltipComponents(IngredientGridTooltipHelper tooltipHelper, IIngredientRenderer<I> ingredientRenderer, IIngredientHelper<I> ingredientHelper) {
        ResourceLocation ingredientName;
        String ingredientModId;
        String recipeModId;
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        ITypedIngredient<I> recipeOutput = this.recipeBookmark.getRecipeOutput();
        R recipe = this.recipeBookmark.getRecipe();
        IRecipeCategory<R> recipeCategory = this.recipeBookmark.getRecipeCategory();
        this.addTooltipComponent(components, (Component)Component.translatable((String)"jei.tooltip.bookmarks.recipe", (Object[])new Object[]{recipeCategory.getTitle()}));
        this.addBookmarkTooltipFeaturesIfEnabled(components);
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        IModIdHelper modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
        ResourceLocation recipeName = recipeCategory.getRegistryName(recipe);
        if (recipeName != null && !(recipeModId = recipeName.getNamespace()).equals(ingredientModId = (ingredientName = ingredientHelper.getResourceLocation(recipeOutput.getIngredient())).getNamespace())) {
            String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
            MutableComponent recipeBy = Component.translatable((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
            this.addTooltipComponent(components, (Component)recipeBy.withStyle(ChatFormatting.GRAY));
        }
        this.addTooltipComponent(components, (Component)Component.empty());
        List<Component> outputTooltip = SafeIngredientUtil.getTooltip(ingredientManager, ingredientRenderer, recipeOutput);
        this.addAllTooltipComponents(components, outputTooltip);
        List<Component> modIdTooltip = new ArrayList<Component>();
        modIdTooltip = modIdHelper.addModNameToIngredientTooltip(modIdTooltip, recipeOutput.getIngredient(), ingredientHelper);
        this.addAllTooltipComponents(components, modIdTooltip);
        return components;
    }

    private void addAllTooltipComponents(List<ClientTooltipComponent> tooltipComponents, List<Component> components) {
        for (Component component : components) {
            this.addTooltipComponent(tooltipComponents, component);
        }
    }

    private void addTooltipComponent(List<ClientTooltipComponent> tooltipComponents, Component component) {
        ClientTooltipComponent clientTooltipComponent = TooltipHelper.toTooltipComponent(component);
        tooltipComponents.add(clientTooltipComponent);
    }

    private void addBookmarkTooltipFeaturesIfEnabled(List<ClientTooltipComponent> components) {
        List<ClientTooltipComponent> transferComponents = this.createTransferComponents();
        if (this.clientConfig.getBookmarkTooltipFeatures().isEmpty() && transferComponents.isEmpty()) {
            return;
        }
        if (this.clientConfig.isHoldShiftToShowBookmarkTooltipFeaturesEnabled()) {
            if (Screen.hasShiftDown()) {
                this.addBookmarkTooltipFeatures(components);
                components.addAll(transferComponents);
            } else {
                ClientTooltipComponent tooltipComponent = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.usage", Component.keybind((String)"jei.key.shift"));
                components.add(tooltipComponent);
            }
        } else {
            this.addBookmarkTooltipFeatures(components);
            components.addAll(transferComponents);
        }
    }

    private void addBookmarkTooltipFeatures(List<ClientTooltipComponent> components) {
        for (BookmarkTooltipFeature feature : this.clientConfig.getBookmarkTooltipFeatures()) {
            Object component = this.cache.get((Object)feature);
            if (component == null) {
                IRecipeLayoutDrawable recipeLayout = this.getRecipeLayoutDrawable().orElse(null);
                if (recipeLayout == null) break;
                component = switch (feature) {
                    default -> throw new MatchException(null, null);
                    case BookmarkTooltipFeature.PREVIEW -> new PreviewTooltipComponent(recipeLayout);
                    case BookmarkTooltipFeature.INGREDIENTS -> new IngredientsTooltipComponent(recipeLayout);
                };
                this.cache.put(feature, (ClientTooltipComponent)component);
            }
            components.add((ClientTooltipComponent)component);
        }
    }

    private List<ClientTooltipComponent> createTransferComponents() {
        ArrayList<ClientTooltipComponent> results = new ArrayList<ClientTooltipComponent>();
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        LocalPlayer player = minecraft.player;
        if (player != null && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            IRecipeTransferError recipeTransferError = this.getRecipeLayoutDrawable().flatMap(arg_0 -> RecipeBookmarkElement.lambda$createTransferComponents$0(containerScreen, (Player)player, arg_0)).orElse(null);
            if (recipeTransferError == null || recipeTransferError.getType().allowsTransfer) {
                IJeiKeyMapping maxTransferRecipeBookmark;
                IInternalKeyMappings keyMappings = Internal.getKeyMappings();
                IJeiKeyMapping transferRecipeBookmark = keyMappings.getTransferRecipeBookmark();
                if (!transferRecipeBookmark.isUnbound()) {
                    ClientTooltipComponent transferUsage = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.transfer.usage", transferRecipeBookmark);
                    results.add(transferUsage);
                }
                if (!(maxTransferRecipeBookmark = keyMappings.getMaxTransferRecipeBookmark()).isUnbound()) {
                    ClientTooltipComponent transferUsage = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.transfer.max.usage", maxTransferRecipeBookmark);
                    results.add(transferUsage);
                }
            }
        }
        return results;
    }

    private Optional<IRecipeLayoutDrawable<R>> getRecipeLayoutDrawable() {
        if (this.cachedLayoutDrawable == null) {
            IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
            IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
            IFocusFactory focusFactory = jeiRuntime.getJeiHelpers().getFocusFactory();
            DrawableNineSliceTexture recipePreviewBackground = Internal.getTextures().getRecipePreviewBackground();
            this.cachedLayoutDrawable = recipeManager.createRecipeLayoutDrawable(this.recipeBookmark.getRecipeCategory(), this.recipeBookmark.getRecipe(), focusFactory.getEmptyFocusGroup(), recipePreviewBackground, 4);
        }
        return this.cachedLayoutDrawable;
    }

    @Override
    public boolean isVisible() {
        return this.recipeBookmark.isVisible();
    }

    private static /* synthetic */ Optional lambda$createTransferComponents$0(AbstractContainerScreen containerScreen, Player player, IRecipeLayoutDrawable recipeLayout) {
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IRecipeTransferManager recipeTransferManager = jeiRuntime.getRecipeTransferManager();
        AbstractContainerMenu container = containerScreen.getMenu();
        return RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, player);
    }
}

