/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.GuiProperties;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class ScreenPropertiesCache {
    private final IScreenHelper screenHelper;
    @Nullable
    private IGuiProperties previousGuiProperties;
    private Set<ImmutableRect2i> previousGuiExclusionAreas = Set.of();
    @Nullable
    private ImmutablePoint2i mouseExclusionArea;

    public ScreenPropertiesCache(IScreenHelper screenHelper) {
        this.screenHelper = screenHelper;
    }

    public Updater getUpdater(Runnable onChange) {
        return new Updater(this, onChange);
    }

    public boolean hasValidScreen() {
        return this.previousGuiProperties != null;
    }

    public Optional<IGuiProperties> getGuiProperties() {
        return Optional.ofNullable(this.previousGuiProperties);
    }

    public Set<ImmutableRect2i> getGuiExclusionAreas() {
        return this.previousGuiExclusionAreas;
    }

    @Nullable
    public ImmutablePoint2i getMouseExclusionArea() {
        return this.mouseExclusionArea;
    }

    public static class Updater {
        private final ScreenPropertiesCache cache;
        private final Runnable onChange;
        private boolean changed = false;

        public Updater(ScreenPropertiesCache cache, Runnable onChange) {
            this.cache = cache;
            this.onChange = onChange;
        }

        public Updater updateScreen(@Nullable Screen guiScreen) {
            IGuiProperties currentGuiProperties = Optional.ofNullable(guiScreen).flatMap(this.cache.screenHelper::getGuiProperties).orElse(null);
            if (!GuiProperties.areEqual(this.cache.previousGuiProperties, currentGuiProperties)) {
                this.cache.previousGuiProperties = currentGuiProperties;
                this.changed = true;
            }
            return this;
        }

        public Updater updateExclusionAreas(Set<ImmutableRect2i> updatedGuiExclusionAreas) {
            if (!this.cache.previousGuiExclusionAreas.equals(updatedGuiExclusionAreas)) {
                this.cache.previousGuiExclusionAreas = updatedGuiExclusionAreas;
                this.changed = true;
            }
            return this;
        }

        public Updater updateMouseExclusionArea(@Nullable ImmutablePoint2i mouseExclusionArea) {
            if (!Objects.equals(this.cache.mouseExclusionArea, mouseExclusionArea)) {
                this.cache.mouseExclusionArea = mouseExclusionArea;
                this.changed = true;
            }
            return this;
        }

        public void update() {
            if (this.changed) {
                this.onChange.run();
            }
        }
    }
}

