/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.screens.Screen;

public class LimitedAreaInputHandler
implements IUserInputHandler {
    private final IUserInputHandler handler;
    private final ImmutableRect2i area;

    public static IUserInputHandler create(IUserInputHandler handler, ImmutableRect2i area) {
        if (area.isEmpty()) {
            return handler;
        }
        return new LimitedAreaInputHandler(handler, area);
    }

    private LimitedAreaInputHandler(IUserInputHandler handler, ImmutableRect2i area) {
        this.handler = handler;
        this.area = area;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("area", (Object)this.area).add("handler", (Object)this.handler).toString();
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (this.area.contains(input.getMouseX(), input.getMouseY())) {
            return this.handler.handleUserInput(screen, input, keyBindings).map(handled -> this);
        }
        return Optional.empty();
    }

    @Override
    public void handleMouseClickedOut(InputConstants.Key input) {
        this.handler.handleMouseClickedOut(input);
    }

    @Override
    public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        if (this.area.contains(mouseX, mouseY)) {
            return this.handler.handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        }
        return Optional.empty();
    }
}

