/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagUtil {
    public static <VALUE, STACK> Optional<ResourceLocation> getTagEquivalent(Collection<STACK> stacks, Function<STACK, VALUE> stackToValue, Supplier<Stream<Pair<TagKey<VALUE>, HolderSet.Named<VALUE>>>> tagSupplier) {
        List values = stacks.stream().map(stackToValue).toList();
        return tagSupplier.get().filter(e -> {
            HolderSet.Named tag = (HolderSet.Named)e.getSecond();
            int count = tag.size();
            if (count == values.size()) {
                return IntStream.range(0, count).allMatch(i -> {
                    Object tagValue = tag.get(i).value();
                    Object value = values.get(i);
                    return value.equals(tagValue);
                });
            }
            return false;
        }).map(e -> ((TagKey)e.getFirst()).location()).findFirst();
    }
}

