/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.runtime.IJeiKeyMapping;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class TooltipHelper {
    public static ClientTooltipComponent createKeyUsageTooltipComponent(String translationKey, IJeiKeyMapping keyMapping) {
        return TooltipHelper.toTooltipComponent(TooltipHelper.createKeyUsageComponent(translationKey, keyMapping));
    }

    public static ClientTooltipComponent createKeyUsageTooltipComponent(String translationKey, MutableComponent keyMapping) {
        return TooltipHelper.toTooltipComponent(TooltipHelper.createKeyUsageComponent(translationKey, keyMapping));
    }

    public static Component createKeyUsageComponent(String translationKey, IJeiKeyMapping keyMapping) {
        MutableComponent translatedKeyMessage = keyMapping.getTranslatedKeyMessage().copy();
        return TooltipHelper.createKeyUsageComponent(translationKey, translatedKeyMessage);
    }

    public static Component createKeyUsageComponent(String translationKey, MutableComponent keyMapping) {
        MutableComponent boldKeyMapping = keyMapping.withStyle(ChatFormatting.BOLD);
        return Component.translatable((String)translationKey, (Object[])new Object[]{boldKeyMapping}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    }

    public static ClientTooltipComponent toTooltipComponent(Component component) {
        return ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText());
    }

    public static List<ClientTooltipComponent> toTooltipComponents(List<Component> components) {
        ArrayList<ClientTooltipComponent> tooltipComponents = new ArrayList<ClientTooltipComponent>(components.size());
        for (Component component : components) {
            tooltipComponents.add(TooltipHelper.toTooltipComponent(component));
        }
        return tooltipComponents;
    }

    public static Component getKeyDisplayName(InputConstants.Key key) {
        if (key.getType() == InputConstants.Type.MOUSE) {
            int value = key.getValue();
            if (value == 0) {
                return Component.translatable((String)"jei.key.mouse.left");
            }
            if (value == 1) {
                return Component.translatable((String)"jei.key.mouse.right");
            }
        }
        return key.getDisplayName();
    }
}

