/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.Constants;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceVariantCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8029;
import net.minecraft.class_8786;

public abstract class AbstractCookingCategory<T extends class_1874>
extends FurnaceVariantCategory<class_8786<T>> {
    private final IDrawable background;
    private final IDrawable icon;
    private final class_2561 localizedName;
    protected final IGuiHelper guiHelper;
    protected final int regularCookTime;

    public AbstractCookingCategory(IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)icon));
        this.localizedName = class_2561.method_43471((String)translationKey);
        this.guiHelper = guiHelper;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void draw(class_8786<T> recipeHolder, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        this.drawExperience(recipeHolder, guiGraphics, 0);
        this.drawCookTime(recipeHolder, guiGraphics, 45);
    }

    protected void drawExperience(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        float experience = recipe.method_8171();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            guiGraphics.method_51439(fontRenderer, (class_2561)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        int cookTime = recipe.method_8167();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)timeString);
            guiGraphics.method_51439(fontRenderer, (class_2561)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((class_1856)recipe.method_8117().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(RecipeUtil.getResultItem(recipe));
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, class_8786<T> recipeHolder, IFocusGroup focuses) {
        acceptor.addWidget(this.createCookingArrowWidget(recipeHolder, new class_8029(24, 18)));
    }

    @Override
    public boolean isHandled(class_8786<T> recipeHolder) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        return !recipe.method_8118();
    }

    @Override
    public class_2960 getRegistryName(class_8786<T> recipe) {
        return recipe.comp_1932();
    }

    protected IRecipeWidget createCookingArrowWidget(class_8786<T> recipeHolder, class_8029 position) {
        return new CookingArrowRecipeWidget<T>(this.guiHelper, recipeHolder, this.regularCookTime, position);
    }

    private static class CookingArrowRecipeWidget<T extends class_1874>
    implements IRecipeWidget {
        private final IDrawableAnimated arrow;
        private final class_8029 position;

        public CookingArrowRecipeWidget(IGuiHelper guiHelper, class_8786<T> recipeHolder, int regularCookTime, class_8029 position) {
            class_1874 recipe = (class_1874)recipeHolder.comp_1933();
            int cookTime = recipe.method_8167();
            if (cookTime <= 0) {
                cookTime = regularCookTime;
            }
            this.arrow = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            this.position = position;
        }

        @Override
        public class_8029 getPosition() {
            return this.position;
        }

        @Override
        public void draw(class_332 guiGraphics, double mouseX, double mouseY) {
            this.arrow.draw(guiGraphics);
        }
    }
}

