/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_1799 ENCHANTED_BOOK = new class_1799((class_1935)class_1802.field_8598);

    private AnvilRecipeMaker() {
    }

    public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        IIngredientHelper<class_1799> ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        return Stream.concat(AnvilRecipeMaker.getRepairRecipes(vanillaRecipeFactory, ingredientHelper), AnvilRecipeMaker.getBookEnchantmentRecipes(vanillaRecipeFactory, ingredientManager, ingredientHelper)).toList();
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager, IIngredientHelper<class_1799> ingredientHelper) {
        class_2378 registry = RegistryUtil.getRegistry(class_7924.field_41265);
        List<EnchantmentData> enchantmentDatas = registry.method_40270().map(EnchantmentData::new).toList();
        return ingredientManager.getAllItemStacks().stream().filter(class_1799::method_7923).flatMap(ingredient -> AnvilRecipeMaker.getBookEnchantmentRecipes(vanillaRecipeFactory, enchantmentDatas, ingredientHelper, ingredient));
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(IVanillaRecipeFactory vanillaRecipeFactory, List<EnchantmentData> enchantmentDatas, IIngredientHelper<class_1799> ingredientHelper, class_1799 ingredient) {
        return enchantmentDatas.stream().filter(data -> data.canEnchant(ingredient)).map(data -> data.getEnchantedBooks(ingredient)).filter(enchantedBooks -> !enchantedBooks.isEmpty()).map(enchantedBooks -> {
            List<class_1799> outputs = AnvilRecipeMaker.getEnchantedIngredients(ingredient, enchantedBooks);
            String ingredientId = ingredientHelper.getUniqueId(ingredient, UidContext.Recipe);
            String ingredientIdPath = ResourceLocationUtil.sanitizePath(ingredientId);
            String id = "enchantment." + ingredientIdPath;
            class_2960 uid = class_2960.method_60655((String)"minecraft", (String)id);
            return vanillaRecipeFactory.createAnvilRecipe(ingredient, (List<class_1799>)enchantedBooks, outputs, uid);
        });
    }

    private static List<class_1799> getEnchantedIngredients(class_1799 ingredient, List<class_1799> enchantedBooks) {
        return enchantedBooks.stream().map(enchantedBook -> AnvilRecipeMaker.getEnchantedIngredient(ingredient, enchantedBook)).toList();
    }

    private static class_1799 getEnchantedIngredient(class_1799 ingredient, class_1799 enchantedBook) {
        class_1799 enchantedIngredient = ingredient.method_7972();
        class_9304 enchantments = class_1890.method_57532((class_1799)enchantedBook);
        class_1890.method_57530((class_1799)enchantedIngredient, (class_9304)enchantments);
        return enchantedIngredient;
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData(class_1834.field_8922.method_8023(), new class_1799((class_1935)class_1802.field_8091), new class_1799((class_1935)class_1802.field_8647), new class_1799((class_1935)class_1802.field_8406), new class_1799((class_1935)class_1802.field_8876), new class_1799((class_1935)class_1802.field_8167)), new RepairData(class_1856.method_8106((class_6862)class_3489.field_15537), new class_1799((class_1935)class_1802.field_8255)), new RepairData(class_1834.field_8927.method_8023(), new class_1799((class_1935)class_1802.field_8528), new class_1799((class_1935)class_1802.field_8387), new class_1799((class_1935)class_1802.field_8062), new class_1799((class_1935)class_1802.field_8776), new class_1799((class_1935)class_1802.field_8431)), new RepairData((class_1856)((class_1741)class_1740.field_7897.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8267), new class_1799((class_1935)class_1802.field_8577), new class_1799((class_1935)class_1802.field_8570), new class_1799((class_1935)class_1802.field_8370)), new RepairData(class_1834.field_8923.method_8023(), new class_1799((class_1935)class_1802.field_8371), new class_1799((class_1935)class_1802.field_8403), new class_1799((class_1935)class_1802.field_8475), new class_1799((class_1935)class_1802.field_8699), new class_1799((class_1935)class_1802.field_8609)), new RepairData((class_1856)((class_1741)class_1740.field_7892.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8743), new class_1799((class_1935)class_1802.field_8523), new class_1799((class_1935)class_1802.field_8396), new class_1799((class_1935)class_1802.field_8660)), new RepairData((class_1856)((class_1741)class_1740.field_7887.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8283), new class_1799((class_1935)class_1802.field_8873), new class_1799((class_1935)class_1802.field_8218), new class_1799((class_1935)class_1802.field_8313)), new RepairData(class_1834.field_8929.method_8023(), new class_1799((class_1935)class_1802.field_8845), new class_1799((class_1935)class_1802.field_8335), new class_1799((class_1935)class_1802.field_8825), new class_1799((class_1935)class_1802.field_8322), new class_1799((class_1935)class_1802.field_8303)), new RepairData((class_1856)((class_1741)class_1740.field_7895.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8862), new class_1799((class_1935)class_1802.field_8678), new class_1799((class_1935)class_1802.field_8416), new class_1799((class_1935)class_1802.field_8753)), new RepairData(class_1834.field_8930.method_8023(), new class_1799((class_1935)class_1802.field_8802), new class_1799((class_1935)class_1802.field_8377), new class_1799((class_1935)class_1802.field_8556), new class_1799((class_1935)class_1802.field_8250), new class_1799((class_1935)class_1802.field_8527)), new RepairData((class_1856)((class_1741)class_1740.field_7889.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8805), new class_1799((class_1935)class_1802.field_8058), new class_1799((class_1935)class_1802.field_8348), new class_1799((class_1935)class_1802.field_8285)), new RepairData(class_1834.field_22033.method_8023(), new class_1799((class_1935)class_1802.field_22022), new class_1799((class_1935)class_1802.field_22025), new class_1799((class_1935)class_1802.field_22026), new class_1799((class_1935)class_1802.field_22023), new class_1799((class_1935)class_1802.field_22024)), new RepairData((class_1856)((class_1741)class_1740.field_21977.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_22030), new class_1799((class_1935)class_1802.field_22027), new class_1799((class_1935)class_1802.field_22029), new class_1799((class_1935)class_1802.field_22028)), new RepairData(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8614}), new class_1799((class_1935)class_1802.field_8833)), new RepairData((class_1856)((class_1741)class_1740.field_7890.comp_349()).comp_2301().get(), new class_1799((class_1935)class_1802.field_8090)));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<class_1799> ingredientHelper) {
        return AnvilRecipeMaker.getRepairData().flatMap(repairData -> AnvilRecipeMaker.getRepairRecipes(repairData, vanillaRecipeFactory, ingredientHelper));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<class_1799> ingredientHelper) {
        class_1856 repairIngredient = repairData.getRepairIngredient();
        List<class_1799> repairables = repairData.getRepairables();
        List<class_1799> repairMaterials = List.of(repairIngredient.method_8105());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            String ingredientIdPath = ResourceLocationUtil.sanitizePath(ingredientHelper.getUniqueId((class_1799)itemStack, UidContext.Recipe));
            String itemModId = ingredientHelper.getResourceLocation((class_1799)itemStack).method_12836();
            class_1799 damagedThreeQuarters = itemStack.method_7972();
            damagedThreeQuarters.method_7974(damagedThreeQuarters.method_7936() * 3 / 4);
            class_1799 damagedHalf = itemStack.method_7972();
            damagedHalf.method_7974(damagedHalf.method_7936() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf), class_2960.method_60655((String)itemModId, (String)("self_repair." + ingredientIdPath)));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                class_1799 damagedFully = itemStack.method_7972();
                damagedFully.method_7974(damagedFully.method_7936());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters), class_2960.method_60655((String)itemModId, (String)("materials_repair." + ingredientIdPath)));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    public static int findLevelsCost(class_1799 leftStack, class_1799 rightStack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return -1;
        }
        class_1661 fakeInventory = new class_1661((class_1657)player);
        try {
            class_1706 repair = new class_1706(0, fakeInventory);
            ((class_1735)repair.field_7761.get(0)).method_7673(leftStack);
            ((class_1735)repair.field_7761.get(1)).method_7673(rightStack);
            return repair.method_17369();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }

    private static class RepairData {
        private final class_1856 repairIngredient;
        private final List<class_1799> repairables;

        public RepairData(class_1856 repairIngredient, class_1799 ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public class_1856 getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<class_1799> getRepairables() {
            return this.repairables;
        }
    }

    private static final class EnchantmentData {
        private final class_6880<class_1887> enchantment;
        private final List<class_1799> enchantedBooks;

        private EnchantmentData(class_6880<class_1887> enchantment) {
            this.enchantment = enchantment;
            this.enchantedBooks = EnchantmentData.getEnchantedBooks(enchantment);
        }

        public List<class_1799> getEnchantedBooks(class_1799 ingredient) {
            IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
            return this.enchantedBooks.stream().filter(enchantedBook -> itemStackHelper.isBookEnchantable(ingredient, (class_1799)enchantedBook)).toList();
        }

        private boolean canEnchant(class_1799 ingredient) {
            try {
                return ((class_1887)this.enchantment.comp_349()).method_8192(ingredient);
            }
            catch (RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(ingredient);
                LOGGER.error("Failed to check if ingredient can be enchanted: {}", (Object)stackInfo, (Object)e);
                return false;
            }
        }

        private static List<class_1799> getEnchantedBooks(class_6880<class_1887> enchantment) {
            return IntStream.rangeClosed(1, ((class_1887)enchantment.comp_349()).method_8183()).mapToObj(level -> {
                class_1799 bookEnchant = ENCHANTED_BOOK.method_7972();
                class_9304.class_9305 itemEnchantments = new class_9304.class_9305(class_1890.method_57532((class_1799)bookEnchant));
                itemEnchantments.method_57547(enchantment, level);
                class_1890.method_57530((class_1799)bookEnchant, (class_9304)itemEnchantments.method_57549());
                return bookEnchant;
            }).toList();
        }
    }
}

