/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes.supplier.builder;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.gui.recipes.layout.builder.RecipeSlotIngredients;
import mezz.jei.library.ingredients.IngredientAcceptor;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class IngredientSlotBuilder
implements IRecipeSlotBuilder {
    private final IngredientAcceptor ingredients;
    private final RecipeIngredientRole role;

    public IngredientSlotBuilder(IIngredientManager ingredientManager, RecipeIngredientRole role) {
        this.ingredients = new IngredientAcceptor(ingredientManager);
        this.role = role;
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        this.ingredients.addIngredients((IIngredientType)ingredientType, (List)ingredients);
        return this;
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.ingredients.addIngredient((IIngredientType)ingredientType, (Object)ingredient);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(class_3611 fluid, long amount) {
        this.ingredients.addFluidStack(fluid, amount);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(class_3611 fluid, long amount, class_9326 componentPatch) {
        this.ingredients.addFluidStack(fluid, amount, componentPatch);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        this.ingredients.addIngredientsUnsafe((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        this.ingredients.addTypedIngredients((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        this.ingredients.addOptionalTypedIngredients((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        return this;
    }

    @Override
    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        return this;
    }

    @Override
    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        return this;
    }

    @Override
    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        return this;
    }

    @Override
    public IRecipeSlotBuilder addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        return this;
    }

    @Override
    public IRecipeSlotBuilder setSlotName(String slotName) {
        return this;
    }

    public RecipeSlotIngredients getRecipeSlotIngredients() {
        return new RecipeSlotIngredients(this.role, this.ingredients.getAllIngredients(), this.ingredients.getIngredientTypes());
    }
}

