/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.helpers;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.ImmutableSize2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_8029;
import net.minecraft.class_8030;

public class ScrollGridRecipeWidget
implements ISlottedRecipeWidget,
IJeiInputHandler {
    public static final int SCROLLBAR_PADDING = 2;
    public static final int SCROLLBAR_WIDTH = 14;
    private static final int MIN_SCROLL_MARKER_HEIGHT = 14;
    private final DrawableNineSliceTexture scrollbarMarker;
    private final DrawableNineSliceTexture scrollbarBackground;
    private final IDrawable slotBackground;
    private final int columns;
    private final int visibleRows;
    private final int hiddenRows;
    private final List<IRecipeSlotDrawable> slots;
    private final class_8030 area;
    private final ImmutableRect2i scrollArea;
    private double dragOriginY = -1.0;
    private float scrollOffsetY = 0.0f;

    public static ImmutableSize2i calculateSize(IDrawable slotBackground, int columns, int visibleRows) {
        return new ImmutableSize2i(columns * slotBackground.getWidth() + 2 + 14, visibleRows * slotBackground.getHeight());
    }

    public ScrollGridRecipeWidget(class_8030 area, int columns, int visibleRows, List<IRecipeSlotDrawable> slots) {
        this.slots = slots;
        Textures textures = Internal.getTextures();
        this.scrollbarMarker = textures.getScrollbarMarker();
        this.scrollbarBackground = textures.getScrollbarBackground();
        this.slotBackground = textures.getSlotDrawable();
        this.columns = columns;
        this.visibleRows = visibleRows;
        this.area = area;
        this.scrollArea = ScrollGridRecipeWidget.calculateScrollArea(area.comp_1196(), area.comp_1197());
        int totalRows = MathUtil.divideCeil(slots.size(), columns);
        this.hiddenRows = Math.max(totalRows - visibleRows, 0);
    }

    @Override
    public class_8029 getPosition() {
        return this.area.comp_1195();
    }

    @Override
    public class_8030 getArea() {
        return this.area;
    }

    private static ImmutableRect2i calculateScrollArea(int width, int height) {
        return new ImmutableRect2i(width - 14, 0, 14, height);
    }

    private ImmutableRect2i calculateScrollbarMarkerArea(int hiddenRows) {
        int totalSpace = this.scrollArea.height() - 2;
        int scrollMarkerWidth = this.scrollArea.width() - 2;
        int scrollMarkerHeight = Math.round((float)totalSpace * ((float)this.visibleRows / (float)(this.visibleRows + hiddenRows)));
        scrollMarkerHeight = Math.max(scrollMarkerHeight, 14);
        int scrollbarMarkerY = Math.round((float)(totalSpace - scrollMarkerHeight) * this.scrollOffsetY);
        return new ImmutableRect2i(this.scrollArea.getX() + 1, this.scrollArea.getY() + 1 + scrollbarMarkerY, scrollMarkerWidth, scrollMarkerHeight);
    }

    @Override
    public void draw(class_332 guiGraphics, double mouseX, double mouseY) {
        this.scrollbarBackground.draw(guiGraphics, this.scrollArea);
        ImmutableRect2i scrollbarMarkerArea = this.calculateScrollbarMarkerArea(this.hiddenRows);
        this.scrollbarMarker.draw(guiGraphics, scrollbarMarkerArea);
        int totalSlots = this.slots.size();
        int firstRow = ScrollGridRecipeWidget.getRowIndexForScroll(this.hiddenRows, this.scrollOffsetY);
        int firstIndex = this.columns * firstRow;
        int slotWidth = this.slotBackground.getWidth();
        int slotHeight = this.slotBackground.getHeight();
        for (int row = 0; row < this.visibleRows; ++row) {
            int y = row * slotHeight;
            for (int column = 0; column < this.columns; ++column) {
                int x = column * slotWidth;
                int slotIndex = firstIndex + row * this.columns + column;
                this.slotBackground.draw(guiGraphics, x, y);
                if (slotIndex >= totalSlots) continue;
                IRecipeSlotDrawable slot = this.slots.get(slotIndex);
                slot.setPosition(x + 1, y + 1);
                slot.draw(guiGraphics);
            }
        }
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        int firstRow = ScrollGridRecipeWidget.getRowIndexForScroll(this.hiddenRows, this.scrollOffsetY);
        int startIndex = firstRow * this.columns;
        int endIndex = Math.min(startIndex + this.visibleRows * this.columns, this.slots.size());
        for (int i = startIndex; i < endIndex; ++i) {
            IRecipeSlotDrawable slot = this.slots.get(i);
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(new RecipeSlotUnderMouse(slot, this.getPosition()));
        }
        return Optional.empty();
    }

    private static int getRowIndexForScroll(int hiddenRows, float scrollOffset) {
        int rowIndex = (int)((double)(scrollOffset * (float)hiddenRows) + 0.5);
        return Math.max(rowIndex, 0);
    }

    private static float subtractInputFromScroll(int hiddenRows, float scrollOffset, double scrollDeltaY) {
        float newScrollOffset = scrollOffset - (float)(scrollDeltaY / (double)hiddenRows);
        return class_3532.method_15363((float)newScrollOffset, (float)0.0f, (float)1.0f);
    }

    @Override
    public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
        if (!userInput.is(Internal.getKeyMappings().getLeftClick())) {
            return false;
        }
        if (!userInput.isSimulate()) {
            this.dragOriginY = -1.0;
        }
        if (this.scrollArea.contains(mouseX, mouseY)) {
            if (this.hiddenRows == 0) {
                return false;
            }
            if (userInput.isSimulate()) {
                ImmutableRect2i scrollMarkerArea = this.calculateScrollbarMarkerArea(this.hiddenRows);
                if (!scrollMarkerArea.contains(mouseX, mouseY)) {
                    this.moveScrollbarCenterTo(scrollMarkerArea, mouseY);
                    scrollMarkerArea = this.calculateScrollbarMarkerArea(this.hiddenRows);
                }
                this.dragOriginY = mouseY - (double)scrollMarkerArea.y();
            }
            return true;
        }
        return false;
    }

    private void moveScrollbarCenterTo(ImmutableRect2i scrollMarkerArea, double centerY) {
        double topY = centerY - (double)scrollMarkerArea.height() / 2.0;
        this.moveScrollbarTo(scrollMarkerArea, topY);
    }

    private void moveScrollbarTo(ImmutableRect2i scrollMarkerArea, double topY) {
        int minY = this.scrollArea.y();
        int maxY = this.scrollArea.y() + this.scrollArea.height() - scrollMarkerArea.height();
        double relativeY = topY - (double)minY;
        int totalSpace = maxY - minY;
        this.scrollOffsetY = (float)(relativeY / (double)totalSpace);
        this.scrollOffsetY = class_3532.method_15363((float)this.scrollOffsetY, (float)0.0f, (float)1.0f);
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        int totalSlots = this.slots.size();
        this.scrollOffsetY = this.hiddenRows > 0 ? ScrollGridRecipeWidget.subtractInputFromScroll(totalSlots, this.scrollOffsetY, scrollDeltaY) : 0.0f;
        return true;
    }

    @Override
    public boolean handleMouseDragged(double mouseX, double mouseY, class_3675.class_306 mouseKey, double dragX, double dragY) {
        if (this.dragOriginY < 0.0 || mouseKey.method_1444() != 0) {
            return false;
        }
        ImmutableRect2i scrollbarMarkerArea = this.calculateScrollbarMarkerArea(this.hiddenRows);
        double topY = mouseY - this.dragOriginY;
        this.moveScrollbarTo(scrollbarMarkerArea, topY);
        return true;
    }
}

