/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.Optional;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.ClickableIngredientInternal;
import mezz.jei.gui.input.DraggableIngredientInternal;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.RenderableElement;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class IngredientListSlot {
    private final ImmutableRect2i area;
    private final int padding;
    private boolean blocked = false;
    @Nullable
    private RenderableElement<?> renderableElement;

    public IngredientListSlot(int xPosition, int yPosition, int width, int height, int padding) {
        this.area = new ImmutableRect2i(xPosition, yPosition, width, height);
        this.padding = padding;
    }

    public Optional<IElement<?>> getElement() {
        return Optional.ofNullable(this.renderableElement).map(RenderableElement::getElement);
    }

    public Optional<IClickableIngredientInternal<?>> getClickableIngredient() {
        return Optional.ofNullable(this.renderableElement).map(RenderableElement::getElement).map(element -> new ClickableIngredientInternal(element, this::isMouseOver, true, true));
    }

    public Optional<IDraggableIngredientInternal<?>> getDraggableIngredient() {
        return Optional.ofNullable(this.renderableElement).map(RenderableElement::getElement).map(element -> new DraggableIngredientInternal(element, this.area));
    }

    public void render(class_332 guiGraphics) {
        if (!this.blocked && this.renderableElement != null) {
            this.renderableElement.render(guiGraphics, this.area, this.padding);
        }
    }

    public void clear() {
        this.renderableElement = null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.renderableElement != null && this.area.contains(mouseX, mouseY);
    }

    public void setElement(RenderableElement<?> renderableElement) {
        this.renderableElement = renderableElement;
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void drawTooltip(class_332 guiGraphics, int mouseX, int mouseY, IngredientGridTooltipHelper tooltipHelper) {
        if (this.renderableElement != null) {
            this.renderableElement.drawTooltip(guiGraphics, mouseX, mouseY, tooltipHelper);
        }
    }
}

