/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.gui.overlay.IngredientListSlot;
import mezz.jei.gui.overlay.elements.ElementRenderer;
import mezz.jei.gui.overlay.elements.ElementRenderers;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.RenderableElement;
import net.minecraft.class_332;

public class IngredientListRenderer {
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final ElementRenderers elementRenderers = new ElementRenderers();
    private int blocked = 0;

    public void clear() {
        this.slots.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public Stream<IngredientListSlot> getSlots() {
        return this.slots.stream().filter(s -> !s.isBlocked());
    }

    public void set(int startIndex, List<IElement<?>> ingredientList) {
        this.blocked = 0;
        ListIterator<IElement<?>> elementIterator = ingredientList.listIterator(startIndex);
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (elementIterator.hasNext()) {
                IElement<?> element = elementIterator.next();
                while (!element.isVisible() && elementIterator.hasNext()) {
                    element = elementIterator.next();
                }
                if (element.isVisible()) {
                    RenderableElement<?> renderableElement = this.createRenderableElement(element);
                    ingredientListSlot.setElement(renderableElement);
                    continue;
                }
                ingredientListSlot.clear();
                continue;
            }
            ingredientListSlot.clear();
        }
    }

    private <T> RenderableElement<T> createRenderableElement(IElement<T> element) {
        ITypedIngredient<T> typedIngredient = element.getTypedIngredient();
        IIngredientType<T> type = typedIngredient.getType();
        ElementRenderer<T> renderer = this.elementRenderers.get(type);
        return new RenderableElement<T>(element, renderer);
    }

    public void render(class_332 guiGraphics) {
        for (IngredientListSlot slot : this.slots) {
            slot.render(guiGraphics);
        }
    }
}

