/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDragHandler;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class GhostIngredientDragManager {
    private final IRecipeFocusSource source;
    private final IScreenHelper screenHelper;
    private final IIngredientManager ingredientManager;
    private final IClientToggleState toggleState;
    private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private ITypedIngredient<?> hoveredIngredient;
    @Nullable
    private List<class_768> hoveredTargetAreas;

    public GhostIngredientDragManager(IRecipeFocusSource source, IScreenHelper screenHelper, IIngredientManager ingredientManager, IClientToggleState toggleState) {
        this.source = source;
        this.screenHelper = screenHelper;
        this.ingredientManager = ingredientManager;
        this.toggleState = toggleState;
    }

    public void drawTooltips(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        if (!(minecraft.field_1755 instanceof class_465)) {
            this.drawGhostIngredientHighlights(minecraft, guiGraphics, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(guiGraphics, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(guiGraphics));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, guiGraphics, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(guiGraphics, mouseX, mouseY);
        } else {
            ITypedIngredient hovered = this.source.getIngredientUnderMouse(mouseX, mouseY).map(IClickableIngredientInternal::getTypedIngredient).findFirst().orElse(null);
            if (!GhostIngredientDragManager.equals(hovered, this.hoveredIngredient)) {
                this.hoveredIngredient = hovered;
                this.hoveredTargetAreas = null;
                class_437 currentScreen = minecraft.field_1755;
                if (currentScreen != null && hovered != null) {
                    this.screenHelper.getGhostIngredientHandler(currentScreen).filter(IGhostIngredientHandler::shouldHighlightTargets).ifPresent(handler -> {
                        this.hoveredTargetAreas = handler.getTargetsTyped(currentScreen, hovered, false).stream().map(IGhostIngredientHandler.Target::getArea).toList();
                    });
                }
            }
            if (this.hoveredTargetAreas != null && !this.toggleState.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(guiGraphics, mouseX, mouseY, this.hoveredTargetAreas);
            }
        }
    }

    private static boolean equals(@Nullable ITypedIngredient<?> a, @Nullable ITypedIngredient<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getIngredient() == b.getIngredient();
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
        }
        this.hoveredIngredient = null;
        this.hoveredTargetAreas = null;
    }

    private <T extends class_437, V> boolean handleClickGhostIngredient(T currentScreen, IDraggableIngredientInternal<V> clicked, UserInput input) {
        return this.screenHelper.getGhostIngredientHandler(currentScreen).map(handler -> {
            ITypedIngredient ingredient = clicked.getTypedIngredient();
            IIngredientType type = ingredient.getType();
            List targets = handler.getTargetsTyped(currentScreen, ingredient, true);
            if (targets.isEmpty()) {
                return false;
            }
            IIngredientRenderer ingredientRenderer = this.ingredientManager.getIngredientRenderer(type);
            ImmutableRect2i clickedArea = clicked.getArea();
            this.ghostIngredientDrag = new GhostIngredientDrag((IGhostIngredientHandler<?>)handler, targets, ingredientRenderer, ingredient, input.getMouseX(), input.getMouseY(), clickedArea);
            return true;
        }).orElse(false);
    }

    public IDragHandler createDragHandler() {
        return new DragHandler();
    }

    private class DragHandler
    implements IDragHandler {
        private DragHandler() {
        }

        @Override
        public Optional<IDragHandler> handleDragStart(class_437 screen, UserInput input) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player == null) {
                return Optional.empty();
            }
            return GhostIngredientDragManager.this.source.getDraggableIngredientUnderMouse(input.getMouseX(), input.getMouseY()).findFirst().flatMap(clicked -> {
                class_1799 mouseItem = player.field_7512.method_34255();
                if (mouseItem.method_7960() && GhostIngredientDragManager.this.handleClickGhostIngredient(screen, clicked, input)) {
                    return Optional.of(this);
                }
                return Optional.empty();
            });
        }

        @Override
        public boolean handleDragComplete(class_437 screen, UserInput input) {
            if (GhostIngredientDragManager.this.ghostIngredientDrag == null) {
                return false;
            }
            boolean success = GhostIngredientDragManager.this.ghostIngredientDrag.onClick(input);
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!success && GhostIngredientDrag.canStart(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY)) {
                GhostIngredientReturning.create(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY).ifPresent(GhostIngredientDragManager.this.ghostIngredientsReturning::add);
            }
            GhostIngredientDragManager.this.ghostIngredientDrag = null;
            GhostIngredientDragManager.this.hoveredTargetAreas = null;
            return success;
        }

        @Override
        public void handleDragCanceled() {
            GhostIngredientDragManager.this.stopDrag();
        }
    }
}

