/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.TypedIngredientSerializer;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import mezz.jei.gui.config.file.serializers.RecipeBookmarkSerializer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BookmarkConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String MARKER_STACK = "T:";
    static final String MARKER_INGREDIENT = "I:";
    static final String LEGACY_MARKER_OTHER = "O:";
    static final String MARKER_RECIPE = "R:";
    private final Path jeiConfigurationDir;

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create bookmark config folder: {}", configPath);
                return Optional.empty();
            }
            Path path = configPath.resolve("bookmarks.ini");
            return Optional.of(path);
        });
    }

    public BookmarkConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    @Override
    public void saveBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, Collection<IBookmark> bookmarks) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
            RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer);
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            for (IBookmark bookmark : bookmarks) {
                if (bookmark instanceof IngredientBookmark) {
                    IngredientBookmark ingredientBookmark = (IngredientBookmark)bookmark;
                    ITypedIngredient typedIngredient = ingredientBookmark.getIngredient();
                    Object patt3110$temp = typedIngredient.getIngredient();
                    if (patt3110$temp instanceof ItemStack) {
                        ItemStack stack = (ItemStack)patt3110$temp;
                        strings.add((CallSite)((Object)(MARKER_STACK + stack.m_41739_(new CompoundTag()))));
                        continue;
                    }
                    strings.add((CallSite)((Object)(MARKER_INGREDIENT + ingredientSerializer.serialize(typedIngredient))));
                    continue;
                }
                if (bookmark instanceof RecipeBookmark) {
                    RecipeBookmark recipeBookmark = (RecipeBookmark)bookmark;
                    strings.add((CallSite)((Object)(MARKER_RECIPE + recipeBookmarkSerializer.serialize(recipeBookmark))));
                    continue;
                }
                LOGGER.error("Unknown IBookmark type, unable to save it: {}", bookmark.getClass());
            }
            try {
                Files.write(path, strings, new OpenOption[0]);
                LOGGER.debug("Saved bookmarks list to file {}", path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save bookmarks list to file {}", path, (Object)e);
            }
        });
    }

    @Override
    public void loadBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, BookmarkList bookmarkList) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            List<String> lines;
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            try {
                lines = Files.readAllLines(path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load bookmarks from file {}", path, (Object)e);
                return;
            }
            TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
            RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer);
            List<IIngredientType<?>> otherIngredientTypes = ingredientManager.getRegisteredIngredientTypes().stream().filter(i -> !i.equals(VanillaTypes.ITEM_STACK)).toList();
            IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
            for (String line : lines) {
                IBookmark bookmark = null;
                if (line.startsWith(MARKER_STACK)) {
                    String itemStackAsJson = line.substring(MARKER_STACK.length());
                    bookmark = BookmarkConfig.loadItemStackBookmark(itemStackHelper, ingredientManager, itemStackAsJson);
                } else if (line.startsWith(MARKER_INGREDIENT)) {
                    String serializedIngredient = line.substring(MARKER_INGREDIENT.length());
                    bookmark = BookmarkConfig.loadIngredientBookmark(ingredientSerializer, ingredientManager, serializedIngredient);
                } else if (line.startsWith(LEGACY_MARKER_OTHER)) {
                    String uid = line.substring(LEGACY_MARKER_OTHER.length());
                    bookmark = BookmarkConfig.loadLegacyIngredientBookmark(otherIngredientTypes, ingredientManager, uid);
                } else if (line.startsWith(MARKER_RECIPE)) {
                    String serializedRecipe = line.substring(MARKER_RECIPE.length());
                    bookmark = BookmarkConfig.loadRecipeBookmark(recipeBookmarkSerializer, serializedRecipe);
                } else {
                    LOGGER.error("Failed to load unknown bookmark type:\n{}", (Object)line);
                }
                if (bookmark == null) continue;
                bookmarkList.addToListWithoutNotifying(bookmark, false);
            }
            bookmarkList.notifyListenersOfChange();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static IBookmark loadItemStackBookmark(IIngredientHelper<ItemStack> itemStackHelper, IIngredientManager ingredientManager, String itemStackAsJson) {
        try {
            CompoundTag itemStackAsNbt = TagParser.m_129359_((String)itemStackAsJson);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemStackAsNbt);
            if (!itemStack.m_41619_()) {
                ItemStack normalized = itemStackHelper.normalizeIngredient(itemStack);
                Optional<ITypedIngredient<ItemStack>> typedIngredient = ingredientManager.createTypedIngredient(VanillaTypes.ITEM_STACK, normalized);
                if (!typedIngredient.isEmpty()) return IngredientBookmark.create(typedIngredient.get(), ingredientManager);
                LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                return null;
            } else {
                LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item is empty:\n{}", (Object)itemStackAsJson);
            }
            return null;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
        }
        return null;
    }

    @Nullable
    static IBookmark loadIngredientBookmark(TypedIngredientSerializer ingredientSerializer, IIngredientManager ingredientManager, String serializedIngredient) {
        IJeiConfigValueSerializer.IDeserializeResult<ITypedIngredient<?>> deserialized = ingredientSerializer.deserialize(serializedIngredient);
        Optional<ITypedIngredient<?>> result = deserialized.getResult();
        if (!result.isEmpty()) {
            return IngredientBookmark.create(result.get(), ingredientManager);
        }
        List<String> errors = deserialized.getErrors();
        LOGGER.warn("Failed to load bookmarked ingredients from string: \n{}\n{}", (Object)serializedIngredient, (Object)String.join((CharSequence)", ", errors));
        return null;
    }

    @Nullable
    private static IBookmark loadLegacyIngredientBookmark(Collection<IIngredientType<?>> otherIngredientTypes, IIngredientManager ingredientManager, String uid) {
        Optional<ITypedIngredient<?>> typedIngredient = BookmarkConfig.getLegacyNormalizedIngredientByUid(ingredientManager, otherIngredientTypes, uid);
        if (!typedIngredient.isEmpty()) {
            return IngredientBookmark.create(typedIngredient.get(), ingredientManager);
        }
        LOGGER.error("Failed to load unknown bookmarked ingredient with uid:\n{}", (Object)uid);
        return null;
    }

    @Nullable
    static IBookmark loadRecipeBookmark(RecipeBookmarkSerializer recipeBookmarkSerializer, String serializedRecipe) {
        IJeiConfigValueSerializer.IDeserializeResult<RecipeBookmark<?, ?>> deserialized = recipeBookmarkSerializer.deserialize(serializedRecipe);
        Optional<RecipeBookmark<?, ?>> result = deserialized.getResult();
        if (!result.isEmpty()) {
            return result.get();
        }
        List<String> errors = deserialized.getErrors();
        LOGGER.warn("Failed to load bookmarked recipe from string: \n{}\n{}", (Object)serializedRecipe, (Object)String.join((CharSequence)", ", errors));
        return null;
    }

    private static Optional<ITypedIngredient<?>> getLegacyNormalizedIngredientByUid(IIngredientManager ingredientManager, Collection<IIngredientType<?>> ingredientTypes, String uid) {
        return ingredientTypes.stream().map(t -> ingredientManager.getTypedIngredientByUid(t, uid)).flatMap(Optional::stream).findFirst();
    }
}

