package mezz.jei.fabric.platform;

import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.fabric.ingredients.fluid.JeiFluidIngredient;
import mezz.jei.library.render.FluidTankRenderer;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1058;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;

@SuppressWarnings("UnstableApiUsage")
public class FluidHelper implements IPlatformFluidHelperInternal<IJeiFluidIngredient> {
	@Override
	public IIngredientTypeWithSubtypes<class_3611, IJeiFluidIngredient> getFluidIngredientType() {
		return FabricTypes.FLUID_STACK;
	}

	@Override
	public IIngredientSubtypeInterpreter<IJeiFluidIngredient> getAllNbtSubtypeInterpreter() {
		return AllFluidNbt.INSTANCE;
	}

	@Override
	public IIngredientRenderer<IJeiFluidIngredient> createRenderer(long capacity, boolean showCapacity, int width, int height) {
		return new FluidTankRenderer<>(this, capacity, showCapacity, width, height);
	}

	@Override
	public Optional<class_1058> getStillFluidSprite(IJeiFluidIngredient ingredient) {
		FluidVariant fluidVariant = getFluidVariant(ingredient);
		class_1058 sprite = FluidVariantRendering.getSprite(fluidVariant);
		return Optional.ofNullable(sprite);
	}

	@Override
	public class_2561 getDisplayName(IJeiFluidIngredient ingredient) {
		FluidVariant fluidVariant = getFluidVariant(ingredient);
		class_2561 displayName = FluidVariantAttributes.getName(fluidVariant);

		class_3611 fluid = fluidVariant.getFluid();
		if (!fluid.method_15793(fluid.method_15785())) {
			return class_2561.method_43469("jei.tooltip.liquid.flowing", displayName);
		}
		return displayName;
	}

	@Override
	public int getColorTint(IJeiFluidIngredient ingredient) {
		FluidVariant fluidVariant = getFluidVariant(ingredient);
		int fluidColor = FluidVariantRendering.getColor(fluidVariant);
		return fluidColor | 0xFF000000;
	}

	@Override
	public void getTooltip(ITooltipBuilder tooltip, IJeiFluidIngredient ingredient, class_1836 tooltipFlag) {
		FluidVariant fluidVariant = getFluidVariant(ingredient);
		List<class_2561> components = FluidVariantRendering.getTooltip(fluidVariant, tooltipFlag);
		tooltip.addAll(components);
	}

	private FluidVariant getFluidVariant(IJeiFluidIngredient ingredient) {
		class_3611 fluid = ingredient.getFluid();
		class_2487 tag = ingredient.getTag().orElse(null);
		return FluidVariant.of(fluid, tag);
	}

	@Override
	public long getAmount(IJeiFluidIngredient ingredient) {
		return ingredient.getAmount();
	}

	@Override
	public Optional<class_2487> getTag(IJeiFluidIngredient ingredient) {
		return ingredient.getTag();
	}

	@SuppressWarnings("UnstableApiUsage")
	@Override
	public long bucketVolume() {
		return FluidConstants.BUCKET;
	}

	@Override
	public IJeiFluidIngredient create(class_3611 fluid, long amount, @Nullable class_2487 tag) {
		return new JeiFluidIngredient(fluid, amount, tag);
	}

	@Override
	public IJeiFluidIngredient create(class_3611 fluid, long amount) {
		return new JeiFluidIngredient(fluid, amount);
	}

	@Override
	public IJeiFluidIngredient copy(IJeiFluidIngredient ingredient) {
		class_2487 tag = ingredient.getTag().orElse(null);
		return new JeiFluidIngredient(ingredient.getFluid(), ingredient.getAmount(), tag);
	}

	@Override
	public IJeiFluidIngredient normalize(IJeiFluidIngredient ingredient) {
		if (ingredient.getAmount() == bucketVolume()) {
			return ingredient;
		}
		class_2487 tag = ingredient.getTag().orElse(null);
		return new JeiFluidIngredient(ingredient.getFluid(), bucketVolume(), tag);
	}

	@Override
	public Optional<IJeiFluidIngredient> getContainedFluid(ITypedIngredient<?> ingredient) {
		return ingredient.getItemStack()
			.map(ContainerItemContext::withConstant)
			.map(c -> c.find(FluidStorage.ITEM))
			.map(Storage::iterator)
			.filter(Iterator::hasNext)
			.map(Iterator::next)
			.map(view -> {
				FluidVariant resource = view.getResource();
				return new JeiFluidIngredient(resource.getFluid(), bucketVolume(), resource.copyNbt());
			});
	}

	private static class AllFluidNbt implements IIngredientSubtypeInterpreter<IJeiFluidIngredient> {
		public static final AllFluidNbt INSTANCE = new AllFluidNbt();

		private AllFluidNbt() {
		}

		@Override
		public String apply(IJeiFluidIngredient storage, UidContext context) {
			return storage.getTag()
				.filter(tag -> !tag.method_33133())
				.map(class_2487::toString)
				.orElse(IIngredientSubtypeInterpreter.NONE);
		}
	}

	@Override
	public IJeiFluidIngredient copyWithAmount(IJeiFluidIngredient ingredient, long amount) {
		class_2487 tag = ingredient.getTag().orElse(null);
		return new JeiFluidIngredient(ingredient.getFluid(), amount, tag);
	}
}
