package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class SuspiciousStewSubtypeInterpreter implements IIngredientSubtypeInterpreter<class_1799> {
	public static final SuspiciousStewSubtypeInterpreter INSTANCE = new SuspiciousStewSubtypeInterpreter();

	private SuspiciousStewSubtypeInterpreter() {

	}

	@Override
	public String apply(class_1799 itemStack, UidContext context) {
		List<String> strings = getPotionEffectStrings(itemStack);
		if (strings.isEmpty()) {
			return IIngredientSubtypeInterpreter.NONE;
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}
		return joiner.toString();
	}

	private static List<String> getPotionEffectStrings(class_1799 itemStack) {
		List<String> effects = new ArrayList<>();
		class_2487 compoundtag = itemStack.method_7969();
		if (compoundtag != null && compoundtag.method_10573("Effects", 9)) {
			class_2499 effectsTag = compoundtag.method_10554("Effects", 10);

			for (int i = 0; i < effectsTag.size(); ++i) {
				class_2487 effectTag = effectsTag.method_10602(i);
				int duration;
				if (effectTag.method_10573("EffectDuration", 99)) {
					duration = effectTag.method_10550("EffectDuration");
				} else {
					duration = 160;
				}

				int effectId = effectTag.method_10550("EffectId");
				effects.add(effectId + "." + duration);
			}
		}
		return effects;
	}
}
