package mezz.jei.common.util;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_777;

public final class QuadUtil {
	private QuadUtil() {}

	public static List<class_777> getQuadsFacingDirection(List<class_777> quads, class_4587 poseStack, class_2350 facing) {
		Matrix4f pose = poseStack.method_23760().method_23761();

		class_2350.class_2351 axis = facing.method_10166();
		float facingStep = facing.method_10171().method_10181();

		return quads
			.stream()
			.filter(q -> {
				class_2350 quadDirection = q.method_3358();
				Vector3f transformedDirection = pose.transformDirection(quadDirection.method_23955());
				double value = axis.method_10172(transformedDirection.x, transformedDirection.y, transformedDirection.z);
				if (facingStep > 0) {
					return value > 0;
				} else {
					return value < 0;
				}
			})
			.toList();
	}
}
