package mezz.jei.api.gui.drawable;

import net.minecraft.class_332;
import net.minecraft.class_768;

/**
 * Similar to {@link IDrawable} but it can scale to any size.
 * Used for backgrounds of UIs and other things that have dynamic size.
 *
 * @since 15.7.0
 */
public interface IScalableDrawable {
	/**
	 * Draw in the given area.
	 *
	 * @since 15.7.0
	 */
	void draw(class_332 guiGraphics, int x, int y, int width, int height);

	/**
	 * Draw in the given area.
	 *
	 * @since 15.7.0
	 */
	default void draw(class_332 guiGraphics, class_768 area) {
		draw(guiGraphics, area.method_3321(), area.method_3322(), area.method_3319(), area.method_3320());
	}
}
