/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.config.IServerConfig;
import mezz.jei.config.ServerConfig;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtilServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtilServer() {
    }

    public static String[] getGiveCommandParameters(Player sender, ItemStack itemStack, int amount) {
        Component senderName = sender.getName();
        Item item = itemStack.getItem();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName.getString());
        Object itemArgument = itemResourceLocation.toString();
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound != null) {
            itemArgument = (String)itemArgument + tagCompound;
        }
        commandStrings.add((String)itemArgument);
        commandStrings.add(String.valueOf(amount));
        return commandStrings.toArray(new String[0]);
    }

    public static void writeChatMessage(Player player, String translationKey, ChatFormatting color) {
        TranslatableComponent component = new TranslatableComponent(translationKey);
        component.getStyle().applyFormat(color);
        player.sendMessage((Component)component, Util.NIL_UUID);
    }

    public static boolean hasPermissionForCheatMode(Player sender) {
        CommandNode<CommandSourceStack> giveCommand;
        MinecraftServer minecraftServer;
        IServerConfig serverConfig = ServerConfig.getInstance();
        if (serverConfig.isCheatModeEnabledForCreative() && sender.isCreative()) {
            return true;
        }
        CommandSourceStack commandSource = sender.createCommandSourceStack();
        if (serverConfig.isCheatModeEnabledForOp() && (minecraftServer = sender.getServer()) != null) {
            int opPermissionLevel = minecraftServer.getOperatorUserPermissionLevel();
            return commandSource.hasPermission(opPermissionLevel);
        }
        if (serverConfig.isCheatModeEnabledForGive() && (giveCommand = CommandUtilServer.getGiveCommand(sender)) != null) {
            return giveCommand.canUse((Object)commandSource);
        }
        return false;
    }

    public static void executeGive(ServerPlayer sender, ItemStack itemStack, GiveMode giveMode) {
        if (CommandUtilServer.hasPermissionForCheatMode((Player)sender)) {
            if (giveMode == GiveMode.INVENTORY) {
                CommandUtilServer.giveToInventory((Player)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                CommandUtilServer.mousePickupItemStack((Player)sender, itemStack);
            }
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPlayer sender, ItemStack itemStack, int hotbarSlot) {
        if (CommandUtilServer.hasPermissionForCheatMode((Player)sender)) {
            if (!Inventory.isHotbarSlot((int)hotbarSlot)) {
                LOGGER.error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.getInventory().getItem(hotbarSlot);
            if (ItemStack.matches((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.copy();
            sender.getInventory().setItem(hotbarSlot, itemStack);
            sender.level.playSound(null, sender.getX(), sender.getY(), sender.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((sender.getRandom().nextFloat() - sender.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.inventoryMenu.broadcastChanges();
            CommandUtilServer.notifyGive((Player)sender, itemStackCopy);
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(Player sender, ItemStack itemStack) {
        int giveCount;
        ItemStack itemStackCopy = itemStack.copy();
        ItemStack existingStack = sender.containerMenu.getCarried();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)itemStack)) {
            int newCount = Math.min(existingStack.getMaxStackSize(), existingStack.getCount() + itemStack.getCount());
            giveCount = newCount - existingStack.getCount();
            existingStack.setCount(newCount);
        } else {
            sender.containerMenu.setCarried(itemStack);
            giveCount = itemStack.getCount();
        }
        if (sender instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)sender;
            itemStackCopy.setCount(giveCount);
            CommandUtilServer.notifyGive((Player)serverPlayerEntity, itemStackCopy);
            serverPlayerEntity.containerMenu.setRemoteCarried(serverPlayerEntity.containerMenu.getCarried());
        }
    }

    private static void giveToInventory(Player entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.copy();
        boolean flag = entityplayermp.getInventory().add(itemStack);
        if (flag && itemStack.isEmpty()) {
            itemStack.setCount(1);
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.makeFakeItem();
            }
            entityplayermp.level.playSound(null, entityplayermp.getX(), entityplayermp.getY(), entityplayermp.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((entityplayermp.getRandom().nextFloat() - entityplayermp.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.setNoPickUpDelay();
                entityitem.setOwner(entityplayermp.getUUID());
            }
        }
        CommandUtilServer.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(Player entityPlayerMP, ItemStack stack) {
        CommandSourceStack commandSource = entityPlayerMP.createCommandSourceStack();
        int count = stack.getCount();
        Component stackTextComponent = stack.getDisplayName();
        Component displayName = entityPlayerMP.getDisplayName();
        TranslatableComponent message = new TranslatableComponent("commands.give.success.single", new Object[]{count, stackTextComponent, displayName});
        commandSource.sendSuccess((Component)message, true);
    }

    @Nullable
    private static CommandNode<CommandSourceStack> getGiveCommand(Player sender) {
        MinecraftServer minecraftServer = sender.getServer();
        if (minecraftServer == null) {
            return null;
        }
        Commands commandManager = minecraftServer.getCommands();
        CommandDispatcher dispatcher = commandManager.getDispatcher();
        RootCommandNode root = dispatcher.getRoot();
        return root.getChild("give");
    }
}

