/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.config.IClientConfig;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveAmount;
import mezz.jei.util.GiveMode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, GiveAmount giveAmount, IClientConfig clientConfig) {
        GiveMode giveMode = clientConfig.getGiveMode();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null) {
            LOGGER.error("Can't give stack, there is no minecraft instance");
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        int amount = giveAmount.getAmountForStack(itemStack);
        if (minecraft.screen instanceof CreativeModeInventoryScreen && giveMode == GiveMode.MOUSE_PICKUP) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            CommandUtilServer.mousePickupItemStack((Player)player, sendStack);
        } else if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            Network.sendPacketToServer(packet);
        } else {
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public static void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)itemStack.getMaxStackSize());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            Network.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.isEmpty()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.getItem();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        LocalPlayer sender = Minecraft.getInstance().player;
        if (sender != null) {
            if (sender.createCommandSourceStack().hasPermission(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.isCreative()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(LocalPlayer sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((Player)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(LocalPlayer sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.chat(chatMessage);
        } else {
            TranslatableComponent errorMessage = new TranslatableComponent("jei.chat.error.command.too.long");
            errorMessage.getStyle().applyFormat(ChatFormatting.RED);
            sender.displayClientMessage((Component)errorMessage, false);
            TextComponent chatMessageComponent = new TextComponent(chatMessage);
            chatMessageComponent.getStyle().applyFormat(ChatFormatting.RED);
            sender.displayClientMessage((Component)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(LocalPlayer sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.getInventory().items.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.getInventory().items.get(i);
            if (currentStack.isEmpty()) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.sameItem(stack) || currentStack.getMaxStackSize() <= currentStack.getCount()) continue;
            int canAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.getCount()));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiPlayerGameMode playerController = minecraft.gameMode;
        if (playerController != null) {
            playerController.handleCreativeModeItemAdd(stack, mainInventorySlot);
        } else {
            LOGGER.error("Cannot send slot packet, minecraft.playerController is null");
        }
    }
}

