/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.ServerInfo;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.transfer.RecipeTransferUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerRecipeTransferHandler
implements IRecipeTransferHandler<InventoryMenu, CraftingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferInfo<InventoryMenu, CraftingRecipe> transferHelper;

    public PlayerRecipeTransferHandler(IStackHelper stackhelper, IRecipeTransferHandlerHelper handlerHelper) {
        this.stackHelper = stackhelper;
        this.handlerHelper = handlerHelper;
        this.transferHelper = new BasicRecipeTransferInfo<InventoryMenu, CraftingRecipe>(InventoryMenu.class, CraftingRecipe.class, VanillaRecipeCategoryUid.CRAFTING, 1, 4, 9, 36);
    }

    @Override
    public Class<InventoryMenu> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public Class<CraftingRecipe> getRecipeClass() {
        return this.transferHelper.getRecipeClass();
    }

    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(InventoryMenu container, CraftingRecipe recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        if (!ServerInfo.isJeiOnServer()) {
            TranslatableComponent tooltipMessage = new TranslatableComponent("jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        if (!this.transferHelper.canHandle(container, recipe)) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container, recipe)) {
            inventorySlots.put(slot.index, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container, recipe)) {
            craftingSlots.put(slot.index, slot);
        }
        IGuiItemStackGroup iGuiItemStackGroup = recipeLayout.getItemStacks();
        int inputCount = 0;
        ImmutableSet badIndexes = ImmutableSet.of((Object)2, (Object)5, (Object)6, (Object)7, (Object)8);
        int inputIndex = 0;
        for (IGuiIngredient ingredient : iGuiItemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput()) continue;
            if (!ingredient.getAllIngredients().isEmpty()) {
                ++inputCount;
                if (badIndexes.contains(inputIndex)) {
                    TranslatableComponent tooltipMessage = new TranslatableComponent("jei.tooltip.error.recipe.transfer.too.large.player.inventory");
                    return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
                }
            }
            ++inputIndex;
        }
        ArrayList guiIngredients = new ArrayList();
        for (IGuiIngredient guiIngredient : iGuiItemStackGroup.getGuiIngredients().values()) {
            if (!guiIngredient.isInput()) continue;
            guiIngredients.add(guiIngredient);
        }
        GuiItemStackGroup playerInvItemStackGroup = new GuiItemStackGroup(null, 0);
        int[] playerGridIndexes = new int[]{0, 1, 3, 4};
        for (int i = 0; i < 4; ++i) {
            int index = playerGridIndexes[i];
            if (index >= guiIngredients.size()) continue;
            IGuiIngredient ingredient = (IGuiIngredient)guiIngredients.get(index);
            playerInvItemStackGroup.init(i, true, 0, 0);
            playerInvItemStackGroup.set(i, ingredient.getAllIngredients());
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.getItem();
            if (stack.isEmpty()) continue;
            if (!slot.mayPickup(player)) {
                LOGGER.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), (Object)slot.index);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.index, stack.copy());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.getItem();
            if (!stack.isEmpty()) {
                availableItemStacks.put(slot.index, stack.copy());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            TranslatableComponent message = new TranslatableComponent("jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip((Component)message);
        }
        RecipeTransferUtil.MatchingItemsResult matchingItemsResult = RecipeTransferUtil.getMatchingItems(this.stackHelper, availableItemStacks, playerInvItemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            TranslatableComponent message = new TranslatableComponent("jei.tooltip.error.recipe.transfer.missing");
            matchingItemsResult = RecipeTransferUtil.getMatchingItems(this.stackHelper, availableItemStacks, iGuiItemStackGroup.getGuiIngredients());
            return this.handlerHelper.createUserErrorForSlots((Component)message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, Integer> entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < container.slots.size()) continue;
            LOGGER.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), (Object)slotNumber, (Object)container.slots.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, false);
            Network.sendPacketToServer(packet);
        }
        return null;
    }
}

