/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.RecipeTransferUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicRecipeTransferHandler<C extends AbstractContainerMenu, R>
implements IRecipeTransferHandler<C, R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferInfo<C, R> transferHelper;

    public BasicRecipeTransferHandler(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IRecipeTransferInfo<C, R> transferHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<C> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public Class<R> getRecipeClass() {
        return this.transferHelper.getRecipeClass();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(C container, R recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        void var9_13;
        if (!ServerInfo.isJeiOnServer()) {
            TranslatableComponent tooltipMessage = new TranslatableComponent("jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        if (!this.transferHelper.canHandle(container, recipe)) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container, recipe)) {
            inventorySlots.put(slot.index, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container, recipe)) {
            craftingSlots.put(slot.index, slot);
        }
        boolean bl = false;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++var9_13;
        }
        if (var9_13 > craftingSlots.size()) {
            LOGGER.error("Recipe Transfer helper {} does not work for container {}. {} ingredients are marked as inputs in IRecipeCategory#setRecipe, but there are only {} crafting slots defined for the recipe transfer helper.", this.transferHelper.getClass(), container.getClass(), (Object)((int)var9_13), (Object)craftingSlots.size());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.getItem();
            if (stack.isEmpty()) continue;
            if (!slot.mayPickup(player)) {
                LOGGER.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), (Object)slot.index);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.index, stack.copy());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.getItem();
            if (!stack.isEmpty()) {
                availableItemStacks.put(slot.index, stack.copy());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - var9_13 > emptySlotCount) {
            TranslatableComponent message = new TranslatableComponent("jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip((Component)message);
        }
        RecipeTransferUtil.MatchingItemsResult matchingItemsResult = RecipeTransferUtil.getMatchingItems(this.stackHelper, availableItemStacks, itemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            TranslatableComponent message = new TranslatableComponent("jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots((Component)message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, Integer> entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < ((AbstractContainerMenu)container).slots.size()) continue;
            LOGGER.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), (Object)slotNumber, (Object)((AbstractContainerMenu)container).slots.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            boolean requireCompleteSets = this.transferHelper.requireCompleteSets(container, recipe);
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, requireCompleteSets);
            Network.sendPacketToServer(packet);
        }
        return null;
    }
}

