/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.PrefixInfo;
import net.minecraft.core.NonNullList;

public class ElementSearchLowMem
implements IElementSearch {
    private final NonNullList<IIngredientListElementInfo<?>> elementInfoList = NonNullList.create();

    @Override
    @Nullable
    public IntSet getSearchResults(String token, PrefixInfo prefixInfo) {
        if (token.isEmpty()) {
            return null;
        }
        int[] results = IntStream.range(0, this.elementInfoList.size()).parallel().filter(i -> {
            IIngredientListElementInfo elementInfo = (IIngredientListElementInfo)this.elementInfoList.get(i);
            return ElementSearchLowMem.matches(token, prefixInfo, elementInfo);
        }).toArray();
        return new IntArraySet(results);
    }

    private static boolean matches(String word, PrefixInfo prefixInfo, IIngredientListElementInfo<?> elementInfo) {
        IIngredientListElement<?> element = elementInfo.getElement();
        if (element.isVisible()) {
            Collection<String> strings = prefixInfo.getStrings(elementInfo);
            for (String string : strings) {
                if (!string.contains(word)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <V> void add(IIngredientListElementInfo<V> info) {
        this.elementInfoList.add(info);
    }

    @Override
    public <V> IIngredientListElementInfo<V> get(int index) {
        IIngredientListElementInfo info = (IIngredientListElementInfo)this.elementInfoList.get(index);
        return info;
    }

    @Override
    public <V> int indexOf(IIngredientListElementInfo<V> ingredient) {
        return this.elementInfoList.indexOf(ingredient);
    }

    @Override
    public int size() {
        return this.elementInfoList.size();
    }

    @Override
    public List<IIngredientListElementInfo<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.elementInfoList);
    }

    @Override
    public void start() {
    }

    @Override
    public void registerPrefix(PrefixInfo prefixInfo) {
    }
}

