/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderProperties;

public class ItemStackFastRenderer
extends IngredientListElementRenderer<ItemStack> {
    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI(MultiBufferSource buffer, PoseStack poseStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI(buffer, poseStack, editModeConfig, worldConfig);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, (ItemStack)this.element.getIngredient());
        }
    }

    private void uncheckedRenderItemAndEffectIntoGUI(MultiBufferSource buffer, PoseStack poseStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(poseStack, this.area, this.padding, editModeConfig);
            RenderSystem.enableBlend();
        }
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        BakedModel bakedModel = itemRenderer.getModel(itemStack, null, null, 0);
        poseStack.pushPose();
        poseStack.translate((double)(this.area.getX() + this.padding) / 16.0, (double)(this.area.getY() + this.padding) / -16.0, 0.0);
        itemRenderer.render(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        poseStack.popPose();
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            ItemStackFastRenderer.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, (ItemStack)this.element.getIngredient());
        }
    }

    private static void renderOverlay(ItemStack itemStack, Rect2i area, int padding) {
        Font font = ItemStackFastRenderer.getFontRenderer(itemStack);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderGuiItemDecorations(font, itemStack, area.getX() + padding, area.getY() + padding, null);
    }

    public static Font getFontRenderer(ItemStack itemStack) {
        Font fontRenderer = RenderProperties.get((ItemStack)itemStack).getFont(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.getInstance().font;
        }
        return fontRenderer;
    }
}

