/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class IngredientListElementRenderer<T> {
    private static final int BLACKLIST_COLOR = -65536;
    private static final Rect2i DEFAULT_AREA = new Rect2i(0, 0, 16, 16);
    protected final IIngredientListElement<T> element;
    protected final IIngredientRenderer<T> ingredientRenderer;
    protected final IIngredientHelper<T> ingredientHelper;
    protected Rect2i area = DEFAULT_AREA;
    protected int padding;

    public IngredientListElementRenderer(IIngredientListElement<T> element) {
        this.element = element;
        T ingredient = element.getIngredient();
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientType<T> ingredientType = ingredientManager.getIngredientType(ingredient);
        this.ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
    }

    public void setArea(Rect2i area) {
        this.area = area;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public IIngredientListElement<T> getElement() {
        return this.element;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public void renderSlow(PoseStack poseStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(poseStack, this.area, this.padding, editModeConfig);
        }
        try {
            T ingredient = this.element.getIngredient();
            this.ingredientRenderer.render(poseStack, this.area.getX() + this.padding, this.area.getY() + this.padding, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    public void drawHighlight(PoseStack poseStack) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.fill((PoseStack)poseStack, (int)this.area.getX(), (int)this.area.getY(), (int)(this.area.getX() + this.area.getWidth()), (int)(this.area.getY() + this.area.getHeight()), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        List<FormattedText> tooltip = this.getTooltip(ingredientFilterConfig, worldConfig);
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, ingredient);
        TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, fontRenderer, ingredient);
    }

    protected void renderEditMode(PoseStack poseStack, Rect2i area, int padding, IEditModeConfig editModeConfig) {
        T ingredient = this.element.getIngredient();
        if (editModeConfig.isIngredientOnConfigBlacklist(ingredient, this.ingredientHelper)) {
            GuiComponent.fill((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-65536);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private List<FormattedText> getTooltip(IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        List<Component> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, this.ingredientRenderer, this.ingredientHelper, modIdHelper);
        ArrayList<Component> tooltip = new ArrayList<Component>(ingredientTooltipSafe);
        Minecraft minecraft = Minecraft.getInstance();
        int maxWidth = 150;
        for (FormattedText formattedText : tooltip) {
            int width = minecraft.font.width(formattedText);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        if (worldConfig.isEditModeEnabled()) {
            IngredientListElementRenderer.addEditModeInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        return tooltip;
    }

    private void addColorSearchInfoToTooltip(Minecraft minecraft, List<FormattedText> tooltip, int maxWidth) {
        T ingredient;
        Iterable<Integer> colors;
        ColorNamer colorNamer = Internal.getColorNamer();
        Collection<String> colorNames = colorNamer.getColorNames(colors = this.ingredientHelper.getColors(ingredient = this.element.getIngredient()), false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            TranslatableComponent colorTranslation = new TranslatableComponent("jei.tooltip.item.colors", new Object[]{colorNamesString});
            MutableComponent colorNamesLocalizedString = colorTranslation.withStyle(ChatFormatting.GRAY);
            tooltip.addAll(minecraft.font.getSplitter().splitLines((FormattedText)colorNamesLocalizedString, maxWidth, Style.EMPTY));
        }
    }

    private static void addEditModeInfoToTooltip(Minecraft minecraft, List<FormattedText> tooltip, int maxWidth) {
        tooltip.add((FormattedText)TextComponent.EMPTY);
        TranslatableComponent description = new TranslatableComponent("gui.jei.editMode.description");
        tooltip.add((FormattedText)description.withStyle(ChatFormatting.DARK_GREEN));
        TranslatableComponent controlKeyLocalization = new TranslatableComponent(Minecraft.ON_OSX ? "key.jei.ctrl.mac" : "key.jei.ctrl");
        TranslatableComponent hide = new TranslatableComponent("gui.jei.editMode.description.hide", new Object[]{controlKeyLocalization});
        MutableComponent hideMessage = hide.withStyle(ChatFormatting.GRAY);
        tooltip.addAll(minecraft.font.getSplitter().splitLines((FormattedText)hideMessage, maxWidth, Style.EMPTY));
        TranslatableComponent hideWild = new TranslatableComponent("gui.jei.editMode.description.hide.wild", new Object[]{controlKeyLocalization});
        MutableComponent hideWildMessage = hideWild.withStyle(ChatFormatting.GRAY);
        tooltip.addAll(minecraft.font.getSplitter().splitLines((FormattedText)hideWildMessage, maxWidth, Style.EMPTY));
    }
}

