/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ISlowRenderItem;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientTypeHelper;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.ItemStackFastRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientListBatchRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final List<ItemStackFastRenderer> renderItems2d = new ArrayList<ItemStackFastRenderer>();
    private final List<ItemStackFastRenderer> renderItems3d = new ArrayList<ItemStackFastRenderer>();
    private final List<IngredientListElementRenderer<?>> renderOther = new ArrayList();
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private int blocked = 0;

    public IngredientListBatchRenderer(IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
    }

    public void clear() {
        this.slots.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public List<IngredientListSlot> getAllGuiIngredientSlots() {
        return this.slots;
    }

    public void set(int startIndex, List<IIngredientListElement<?>> ingredientList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                IIngredientListElement<?> element = ingredientList.get(i);
                this.set(ingredientListSlot, element);
            }
            ++i;
        }
    }

    private <V> void set(IngredientListSlot ingredientListSlot, IIngredientListElement<V> element) {
        ingredientListSlot.clear();
        IIngredientListElement<ItemStack> itemStackElement = IngredientTypeHelper.checkedCast(element, VanillaTypes.ITEM);
        if (itemStackElement != null) {
            BakedModel bakedModel;
            ItemStack itemStack = itemStackElement.getIngredient();
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                LOGGER.error("Minecraft instance is missing");
                return;
            }
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            try {
                bakedModel = itemRenderer.getModel(itemStack, null, null, 0);
                Preconditions.checkNotNull((Object)bakedModel, (Object)"IBakedModel must not be null.");
            }
            catch (Throwable throwable) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                LOGGER.error("ItemStack crashed getting IBakedModel. {}", (Object)stackInfo, (Object)throwable);
                return;
            }
            if (!(bakedModel.isCustomRenderer() || bakedModel.isLayered() || itemStack.getItem() instanceof ISlowRenderItem)) {
                ItemStackFastRenderer renderer = new ItemStackFastRenderer(itemStackElement);
                ingredientListSlot.setIngredientRenderer(renderer);
                if (bakedModel.usesBlockLight()) {
                    this.renderItems3d.add(renderer);
                } else {
                    this.renderItems2d.add(renderer);
                }
                return;
            }
        }
        IngredientListElementRenderer<V> renderer = new IngredientListElementRenderer<V>(element);
        ingredientListSlot.setIngredientRenderer(renderer);
        this.renderOther.add(renderer);
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        IngredientListElementRenderer<?> hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            IIngredientListElement<?> element = hovered.getElement();
            return ClickedIngredient.create(element.getIngredient(), hovered.getArea());
        }
        return null;
    }

    @Nullable
    public IngredientListElementRenderer<?> getHovered(double mouseX, double mouseY) {
        for (IngredientListSlot slot : this.slots) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return slot.getIngredientRenderer();
        }
        return null;
    }

    public <T> Optional<IngredientListElementRenderer<T>> getHovered(double mouseX, double mouseY, IIngredientType<T> ingredientType) {
        return this.slots.stream().filter(s -> s.isMouseOver(mouseX, mouseY)).map(s -> s.getIngredientRenderer(ingredientType)).filter(Objects::nonNull).findFirst();
    }

    public void render(Minecraft minecraft, PoseStack poseStack) {
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        itemRenderer.blitOffset += 50.0f;
        TextureManager textureManager = minecraft.getTextureManager();
        textureManager.getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI((MultiBufferSource)buffer, poseStack, this.editModeConfig, this.worldConfig);
        }
        IngredientListBatchRenderer.renderBatch(itemRenderer, buffer);
        Lighting.setupForFlatItems();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI((MultiBufferSource)buffer, poseStack, this.editModeConfig, this.worldConfig);
        }
        IngredientListBatchRenderer.renderBatch(itemRenderer, buffer);
        Lighting.setupFor3DItems();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        textureManager.getTexture(InventoryMenu.BLOCK_ATLAS).restoreLastBlurMipmap();
        itemRenderer.blitOffset -= 50.0f;
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderOverlay();
        }
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderOverlay();
        }
        RenderSystem.applyModelViewMatrix();
        for (IngredientListElementRenderer ingredientListElementRenderer : this.renderOther) {
            ingredientListElementRenderer.renderSlow(poseStack, this.editModeConfig, this.worldConfig);
        }
    }

    private static void renderBatch(ItemRenderer itemRenderer, MultiBufferSource.BufferSource buffer) {
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushPose();
        modelViewStack.translate(16.0, 0.0, (double)(100.0f + itemRenderer.blitOffset));
        modelViewStack.scale(16.0f, -16.0f, 16.0f);
        modelViewStack.translate(-0.5, -0.5, -0.5);
        RenderSystem.applyModelViewMatrix();
        buffer.endBatch();
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }
}

