/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.RenderProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void render(PoseStack poseStack, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushPose();
            modelViewStack.mulPoseMatrix(poseStack.last().pose());
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            Font font = this.getFontRenderer(minecraft, ingredient);
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            itemRenderer.renderAndDecorateFakeItem(ingredient, xPosition, yPosition);
            itemRenderer.renderGuiItemDecorations(font, ingredient, xPosition, yPosition, null);
            RenderSystem.disableBlend();
            modelViewStack.popPose();
        }
    }

    @Override
    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        try {
            return ingredient.getTooltipLines((Player)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<Component> list = new ArrayList<Component>();
            TranslatableComponent crash = new TranslatableComponent("jei.tooltip.error.crash");
            list.add((Component)crash.withStyle(ChatFormatting.RED));
            return list;
        }
    }

    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        Font fontRenderer = RenderProperties.get((ItemStack)ingredient).getFont(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.font;
        }
        return fontRenderer;
    }
}

