/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StackHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        for (CreativeModeTab itemGroup : CreativeModeTab.TABS) {
            if (itemGroup == CreativeModeTab.TAB_HOTBAR || itemGroup == CreativeModeTab.TAB_INVENTORY) continue;
            NonNullList creativeTabItemStacks = NonNullList.create();
            try {
                itemGroup.fillItemList(creativeTabItemStacks);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting items.Some items from this group will be missing from the ingredient list. {}", (Object)itemGroup, (Object)e);
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.isEmpty()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                ItemStackListFactory.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        return itemList;
    }

    private static void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        String itemKey;
        if (stack.getItem() == Items.PLAYER_HEAD) {
            return;
        }
        try {
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }
}

