/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting.replacers;

import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;

public final class SuspiciousStewRecipeMaker {
    public static Stream<CraftingRecipe> createRecipes() {
        String group = "jei.suspicious.stew";
        Ingredient brownMushroom = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_MUSHROOM.asItem()});
        Ingredient redMushroom = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_MUSHROOM.asItem()});
        Ingredient bowl = Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL});
        return BlockTags.SMALL_FLOWERS.getValues().stream().filter(FlowerBlock.class::isInstance).map(FlowerBlock.class::cast).map(flowerBlock -> {
            Ingredient flower = Ingredient.of((ItemLike[])new ItemLike[]{flowerBlock.asItem()});
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{brownMushroom, redMushroom, bowl, flower});
            ItemStack output = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW, 1);
            MobEffect mobeffect = flowerBlock.getSuspiciousStewEffect();
            SuspiciousStewItem.saveMobEffect((ItemStack)output, (MobEffect)mobeffect, (int)flowerBlock.getEffectDuration());
            ResourceLocation id = new ResourceLocation("minecraft", "jei.suspicious.stew." + flowerBlock.getDescriptionId());
            return new ShapelessRecipe(id, group, output, inputs);
        });
    }

    private SuspiciousStewRecipeMaker() {
    }
}

