/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.cooking.AbstractCookingCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.block.Blocks;

public class CampfireCategory
extends AbstractCookingCategory<CampfireCookingRecipe> {
    private final IDrawable background;

    public CampfireCategory(IGuiHelper guiHelper) {
        super(guiHelper, Blocks.CAMPFIRE, "gui.jei.category.campfire", 400);
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 186, 82, 34).addPadding(0, 10, 0, 0).build();
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.CAMPFIRE;
    }

    @Override
    public Class<? extends CampfireCookingRecipe> getRecipeClass() {
        return CampfireCookingRecipe.class;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void draw(CampfireCookingRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(poseStack, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 24, 8);
        this.drawCookTime(recipe, poseStack, 35);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, CampfireCookingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 8);
        guiItemStacks.set(ingredients);
    }
}

