/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.compostable;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.plugins.vanilla.compostable.CompostableRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ComposterBlock;

public class CompostableRecipeMaker {
    public static List<CompostableRecipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<CompostableRecipe> recipes = new ArrayList<CompostableRecipe>();
        Object2FloatMap compostables = ComposterBlock.COMPOSTABLES;
        Collection<ItemStack> allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        for (ItemStack itemStack : allItemStacks) {
            Item item = itemStack.getItem();
            float compostValue = compostables.getOrDefault((Object)item, 0.0f);
            if (!(compostValue > 0.0f)) continue;
            CompostableRecipe recipe = new CompostableRecipe(itemStack, compostValue);
            recipes.add(recipe);
        }
        recipes.sort(Comparator.comparingDouble(CompostableRecipe::getChance));
        return recipes;
    }
}

