/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack ENCHANTED_BOOK = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);

    private AnvilRecipeMaker() {
    }

    public static List<Object> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            AnvilRecipeMaker.getRepairRecipes(recipes, vanillaRecipeFactory);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create repair recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered vanilla repair recipes in {}", (Object)sw);
        sw.reset();
        sw.start();
        try {
            AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, ingredientManager);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create enchantment recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered enchantment recipes in {}", (Object)sw);
        return recipes;
    }

    private static void getBookEnchantmentRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        Collection<ItemStack> ingredients = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValues();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.isEnchantable()) continue;
            for (Enchantment enchantment : enchantments) {
                if (!enchantment.canEnchant(ingredient)) continue;
                try {
                    AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, enchantment, ingredient);
                }
                catch (RuntimeException e) {
                    String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient);
                    LOGGER.error("Failed to register book enchantment recipes for ingredient: {}", (Object)ingredientInfo, (Object)e);
                }
            }
        }
    }

    private static void getBookEnchantmentRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory, Enchantment enchantment, ItemStack ingredient) {
        Item item = ingredient.getItem();
        ArrayList perLevelBooks = Lists.newArrayList();
        ArrayList perLevelOutputs = Lists.newArrayList();
        for (int level = 1; level <= enchantment.getMaxLevel(); ++level) {
            Map<Enchantment, Integer> enchMap = Collections.singletonMap(enchantment, level);
            ItemStack bookEnchant = ENCHANTED_BOOK.copy();
            EnchantmentHelper.setEnchantments(enchMap, (ItemStack)bookEnchant);
            if (!item.isBookEnchantable(ingredient, bookEnchant)) continue;
            perLevelBooks.add(bookEnchant);
            ItemStack withEnchant = ingredient.copy();
            EnchantmentHelper.setEnchantments(enchMap, (ItemStack)withEnchant);
            perLevelOutputs.add(withEnchant);
        }
        if (!perLevelBooks.isEmpty() && !perLevelOutputs.isEmpty()) {
            IJeiAnvilRecipe anvilRecipe = vanillaRecipeFactory.createAnvilRecipe(ingredient, (List<ItemStack>)perLevelBooks, (List<ItemStack>)perLevelOutputs);
            recipes.add(anvilRecipe);
        }
    }

    private static void getRepairRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory) {
        HashMap items = Maps.newHashMap();
        Ingredient repairWoods = Tiers.WOOD.getRepairIngredient();
        items.put(repairWoods, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.WOODEN_SWORD), new ItemStack((ItemLike)Items.WOODEN_PICKAXE), new ItemStack((ItemLike)Items.WOODEN_AXE), new ItemStack((ItemLike)Items.WOODEN_SHOVEL), new ItemStack((ItemLike)Items.WOODEN_HOE)}));
        Ingredient repairShields = Ingredient.of((Tag)ItemTags.PLANKS);
        items.put(repairShields, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.SHIELD)}));
        items.put(Tiers.STONE.getRepairIngredient(), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.STONE_SWORD), new ItemStack((ItemLike)Items.STONE_PICKAXE), new ItemStack((ItemLike)Items.STONE_AXE), new ItemStack((ItemLike)Items.STONE_SHOVEL), new ItemStack((ItemLike)Items.STONE_HOE)}));
        Ingredient repairLeather = ArmorMaterials.LEATHER.getRepairIngredient();
        items.put(repairLeather, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.LEATHER_HELMET), new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), new ItemStack((ItemLike)Items.LEATHER_BOOTS)}));
        Ingredient repairIronItems = Tiers.IRON.getRepairIngredient();
        items.put(repairIronItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.IRON_SWORD), new ItemStack((ItemLike)Items.IRON_PICKAXE), new ItemStack((ItemLike)Items.IRON_AXE), new ItemStack((ItemLike)Items.IRON_SHOVEL), new ItemStack((ItemLike)Items.IRON_HOE)}));
        Ingredient repairIronArmor = ArmorMaterials.IRON.getRepairIngredient();
        items.put(repairIronArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.IRON_HELMET), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), new ItemStack((ItemLike)Items.IRON_LEGGINGS), new ItemStack((ItemLike)Items.IRON_BOOTS)}));
        Ingredient repairChain = ArmorMaterials.CHAIN.getRepairIngredient();
        items.put(repairChain, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS)}));
        Ingredient repairGoldItems = Tiers.GOLD.getRepairIngredient();
        items.put(repairGoldItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLDEN_SWORD), new ItemStack((ItemLike)Items.GOLDEN_PICKAXE), new ItemStack((ItemLike)Items.GOLDEN_AXE), new ItemStack((ItemLike)Items.GOLDEN_SHOVEL), new ItemStack((ItemLike)Items.GOLDEN_HOE)}));
        Ingredient repairGoldArmor = ArmorMaterials.GOLD.getRepairIngredient();
        items.put(repairGoldArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLDEN_HELMET), new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), new ItemStack((ItemLike)Items.GOLDEN_BOOTS)}));
        Ingredient repairDiamondItems = Tiers.DIAMOND.getRepairIngredient();
        items.put(repairDiamondItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_SWORD), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.DIAMOND_AXE), new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), new ItemStack((ItemLike)Items.DIAMOND_HOE)}));
        Ingredient repairDiamondArmor = ArmorMaterials.DIAMOND.getRepairIngredient();
        items.put(repairDiamondArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_HELMET), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), new ItemStack((ItemLike)Items.DIAMOND_BOOTS)}));
        Ingredient repairNetheriteItems = Tiers.NETHERITE.getRepairIngredient();
        items.put(repairNetheriteItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_SWORD), new ItemStack((ItemLike)Items.NETHERITE_AXE), new ItemStack((ItemLike)Items.NETHERITE_HOE), new ItemStack((ItemLike)Items.NETHERITE_SHOVEL), new ItemStack((ItemLike)Items.NETHERITE_PICKAXE)}));
        Ingredient repairNetheriteArmor = ArmorMaterials.NETHERITE.getRepairIngredient();
        items.put(repairNetheriteArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_BOOTS), new ItemStack((ItemLike)Items.NETHERITE_HELMET), new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE)}));
        Ingredient repairElytra = Ingredient.of((ItemLike[])new ItemLike[]{Items.PHANTOM_MEMBRANE});
        items.put(repairElytra, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.ELYTRA)}));
        Ingredient repairTurtle = ArmorMaterials.TURTLE.getRepairIngredient();
        items.put(repairTurtle, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.TURTLE_HELMET)}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).getItems());
            for (ItemStack ingredient : (List)entry.getValue()) {
                ItemStack damaged1 = ingredient.copy();
                damaged1.setDamageValue(damaged1.getMaxDamage());
                ItemStack damaged2 = ingredient.copy();
                damaged2.setDamageValue(damaged2.getMaxDamage() * 3 / 4);
                ItemStack damaged3 = ingredient.copy();
                damaged3.setDamageValue(damaged3.getMaxDamage() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(damaged1, (List<ItemStack>)repairMaterials, Collections.singletonList(damaged2));
                    recipes.add(repairWithMaterial);
                }
                IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithSame);
            }
        }
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return -1;
        }
        Inventory fakeInventory = new Inventory((Player)player);
        try {
            AnvilMenu repair = new AnvilMenu(0, fakeInventory);
            ((Slot)repair.slots.get(0)).set(leftStack);
            ((Slot)repair.slots.get(1)).set(rightStack);
            return repair.getCost();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }
}

