/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeDisplayData;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class AnvilRecipeCategory
implements IRecipeCategory<AnvilRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<AnvilRecipe, AnvilRecipeDisplayData> cachedDisplayData;

    public AnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 20, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient(new ItemStack((ItemLike)Blocks.ANVIL));
        this.cachedDisplayData = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<AnvilRecipe, AnvilRecipeDisplayData>(){

            public AnvilRecipeDisplayData load(AnvilRecipe key) {
                return new AnvilRecipeDisplayData();
            }
        });
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.ANVIL;
    }

    @Override
    public Class<? extends AnvilRecipe> getRecipeClass() {
        return AnvilRecipe.class;
    }

    @Override
    public Component getTitle() {
        return Blocks.ANVIL.getName();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setIngredients(AnvilRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getOutputs());
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, AnvilRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 49, 0);
        guiItemStacks.init(2, false, 107, 0);
        guiItemStacks.set(ingredients);
        AnvilRecipeDisplayData displayData = (AnvilRecipeDisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        displayData.setCurrentIngredients(guiItemStacks.getGuiIngredients());
    }

    @Override
    public void draw(AnvilRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        AnvilRecipeDisplayData displayData = (AnvilRecipeDisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients = displayData.getCurrentIngredients();
        if (currentIngredients == null) {
            return;
        }
        ItemStack newLeftStack = currentIngredients.get(0).getDisplayedIngredient();
        ItemStack newRightStack = currentIngredients.get(1).getDisplayedIngredient();
        if (newLeftStack == null || newRightStack == null) {
            return;
        }
        ItemStack lastLeftStack = displayData.getLastLeftStack();
        ItemStack lastRightStack = displayData.getLastRightStack();
        int lastCost = displayData.getLastCost();
        if (lastLeftStack == null || lastRightStack == null || !ItemStack.matches((ItemStack)lastLeftStack, (ItemStack)newLeftStack) || !ItemStack.matches((ItemStack)lastRightStack, (ItemStack)newRightStack)) {
            lastCost = AnvilRecipeMaker.findLevelsCost(newLeftStack, newRightStack);
            displayData.setLast(newLeftStack, newRightStack, lastCost);
        }
        if (lastCost != 0) {
            String costText = lastCost < 0 ? "err" : Integer.toString(lastCost);
            String text = I18n.get((String)"container.repair.cost", (Object[])new Object[]{costText});
            Minecraft minecraft = Minecraft.getInstance();
            int mainColor = -8323296;
            LocalPlayer player = minecraft.player;
            if (!(player == null || lastCost < 40 && lastCost <= player.experienceLevel || player.isCreative())) {
                mainColor = -40864;
            }
            this.drawRepairCost(minecraft, poseStack, text, mainColor);
        }
    }

    private void drawRepairCost(Minecraft minecraft, PoseStack poseStack, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.font.width(text);
        int x = this.background.getWidth() - 2 - width;
        int y = 27;
        minecraft.font.draw(poseStack, text, (float)(x + 1), (float)y, shadowColor);
        minecraft.font.draw(poseStack, text, (float)x, (float)(y + 1), shadowColor);
        minecraft.font.draw(poseStack, text, (float)(x + 1), (float)(y + 1), shadowColor);
        minecraft.font.draw(poseStack, text, (float)x, (float)y, mainColor);
    }
}

