/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.ingredients;

import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.util.CommandUtilServer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DebugIngredientHelper
implements IIngredientHelper<DebugIngredient> {
    @Override
    public IIngredientType<DebugIngredient> getIngredientType() {
        return DebugIngredient.TYPE;
    }

    @Override
    @Nullable
    public DebugIngredient getMatch(Iterable<DebugIngredient> ingredients, DebugIngredient ingredientToMatch, UidContext context) {
        for (DebugIngredient debugIngredient : ingredients) {
            String keyRhs;
            String keyLhs;
            if (debugIngredient.getNumber() != ingredientToMatch.getNumber() || !(keyLhs = this.getUniqueId(ingredientToMatch, context)).equals(keyRhs = this.getUniqueId(debugIngredient, context))) continue;
            return debugIngredient;
        }
        return null;
    }

    @Override
    public String getDisplayName(DebugIngredient ingredient) {
        return "JEI Debug Item #" + ingredient.getNumber();
    }

    @Override
    public String getUniqueId(DebugIngredient ingredient, UidContext context) {
        return "JEI_debug_" + ingredient.getNumber();
    }

    @Override
    public String getModId(DebugIngredient ingredient) {
        return "jei";
    }

    @Override
    public String getResourceId(DebugIngredient ingredient) {
        return "debug_" + ingredient.getNumber();
    }

    @Override
    public ItemStack getCheatItemStack(DebugIngredient ingredient) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            CommandUtilServer.writeChatMessage((Player)player, "Debug ingredients cannot be cheated", ChatFormatting.RED);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public DebugIngredient copyIngredient(DebugIngredient ingredient) {
        return ingredient.copy();
    }

    @Override
    public String getErrorInfo(@Nullable DebugIngredient ingredient) {
        if (ingredient == null) {
            return "debug ingredient: null";
        }
        return this.getDisplayName(ingredient);
    }
}

