/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<FormattedText> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<FormattedText> descriptionLines = IngredientInfoRecipe.expandNewlines(descriptionComponents);
        descriptionLines = IngredientInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.getInstance();
        Objects.requireNonNull(minecraft.font);
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.visit((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.EMPTY);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<FormattedText> wrapDescriptionLines(List<FormattedText> descriptionLines) {
        Minecraft minecraft = Minecraft.getInstance();
        ArrayList<FormattedText> descriptionLinesWrapped = new ArrayList<FormattedText>();
        for (FormattedText descriptionLine : descriptionLines) {
            List textLines = minecraft.font.getSplitter().splitLines(descriptionLine, 160, Style.EMPTY);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<FormattedText> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }

    private static class ExpandNewLineTextAcceptor
    implements FormattedText.StyledContentConsumer<Void> {
        private final List<FormattedText> lines = new ArrayList<FormattedText>();
        @Nullable
        private MutableComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> accept(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((FormattedText)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add((FormattedText)TextComponent.EMPTY);
                    continue;
                }
                TextComponent textComponent = new TextComponent(s);
                textComponent.setStyle(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.getStyle().isEmpty() && !this.lastComponent.getStyle().equals((Object)style)) {
                            this.lastComponent = new TextComponent("").append((Component)this.lastComponent);
                        }
                        this.lastComponent.append((Component)textComponent);
                        continue;
                    }
                    this.lines.add((FormattedText)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((FormattedText)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<FormattedText> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((FormattedText)this.lastComponent);
            }
        }
    }
}

