/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.transfer.BasicRecipeTransferHandlerServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketRecipeTransfer
extends PacketJei {
    public final Map<Integer, Integer> recipeMap;
    public final List<Integer> craftingSlots;
    public final List<Integer> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeVarInt(this.recipeMap.size());
        for (Map.Entry<Integer, Integer> recipeMapEntry : this.recipeMap.entrySet()) {
            buf.writeVarInt(recipeMapEntry.getKey().intValue());
            buf.writeVarInt(recipeMapEntry.getValue().intValue());
        }
        buf.writeVarInt(this.craftingSlots.size());
        for (Integer craftingSlot : this.craftingSlots) {
            buf.writeVarInt(craftingSlot.intValue());
        }
        buf.writeVarInt(this.inventorySlots.size());
        for (Integer inventorySlot : this.inventorySlots) {
            buf.writeVarInt(inventorySlot.intValue());
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public static void readPacketData(FriendlyByteBuf buf, Player player) {
        int recipeMapSize = buf.readVarInt();
        HashMap<Integer, Integer> recipeMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < recipeMapSize; ++i) {
            int slotIndex = buf.readVarInt();
            int recipeItem = buf.readVarInt();
            recipeMap.put(slotIndex, recipeItem);
        }
        int craftingSlotsSize = buf.readVarInt();
        ArrayList<Integer> craftingSlots = new ArrayList<Integer>();
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.readVarInt();
            craftingSlots.add(slotIndex);
        }
        int inventorySlotsSize = buf.readVarInt();
        ArrayList<Integer> inventorySlots = new ArrayList<Integer>();
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.readVarInt();
            inventorySlots.add(slotIndex);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        BasicRecipeTransferHandlerServer.setItems(player, recipeMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

