/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import mezz.jei.config.IWorldConfig;
import mezz.jei.network.PacketIdClient;
import mezz.jei.network.packets.IPacketJeiHandler;
import mezz.jei.network.packets.PacketCheatPermission;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PacketHandlerClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public final EnumMap<PacketIdClient, IPacketJeiHandler> clientHandlers = new EnumMap(PacketIdClient.class);

    public PacketHandlerClient(IWorldConfig worldConfig) {
        this.clientHandlers.put(PacketIdClient.CHEAT_PERMISSION, (buf, player) -> PacketCheatPermission.readPacketData(buf, player, worldConfig));
    }

    public void onPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        try {
            FriendlyByteBuf packetBuffer = new FriendlyByteBuf((ByteBuf)event.getPayload());
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IPacketJeiHandler packetHandler = this.clientHandlers.get(packetId);
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                packetHandler.readPacketData(packetBuffer, (Player)player);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Packet error", e);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }
}

