/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.List;
import mezz.jei.events.EventBusHelper;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.ICharTypedHandler;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CombinedUserInputHandler;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenEvent;

public class InputEventHandler {
    private final List<ICharTypedHandler> charTypedHandlers;
    private final CombinedUserInputHandler inputHandler;

    public InputEventHandler(List<ICharTypedHandler> charTypedHandlers, CombinedUserInputHandler inputHandler) {
        this.charTypedHandlers = charTypedHandlers;
        this.inputHandler = inputHandler;
    }

    public void registerToEventBus() {
        EventBusHelper.registerWeakListener(this, ScreenEvent.InitScreenEvent.class, InputEventHandler::onInitGuiEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.KeyboardKeyPressedEvent.Pre.class, InputEventHandler::onKeyboardKeyPressedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.KeyboardKeyPressedEvent.Post.class, InputEventHandler::onKeyboardKeyPressedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.KeyboardCharTypedEvent.Pre.class, InputEventHandler::onKeyboardCharTypedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.KeyboardCharTypedEvent.Post.class, InputEventHandler::onKeyboardCharTypedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.MouseClickedEvent.Pre.class, InputEventHandler::onGuiMouseClickedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.MouseReleasedEvent.Pre.class, InputEventHandler::onGuiMouseReleasedEvent);
        EventBusHelper.registerWeakListener(this, ScreenEvent.MouseScrollEvent.Pre.class, InputEventHandler::onGuiMouseScrollEvent);
    }

    public void onInitGuiEvent(ScreenEvent.InitScreenEvent event) {
        this.inputHandler.handleGuiChange();
    }

    public void onKeyboardKeyPressedEvent(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        UserInput input;
        IUserInputHandler handler;
        Screen screen = event.getScreen();
        if (!InputEventHandler.isContainerTextFieldFocused(screen) && (handler = this.inputHandler.handleUserInput(screen, input = UserInput.fromEvent((ScreenEvent.KeyboardKeyEvent)event))) != null) {
            event.setCanceled(true);
        }
    }

    public void onKeyboardKeyPressedEvent(ScreenEvent.KeyboardKeyPressedEvent.Post event) {
        UserInput input;
        IUserInputHandler handler;
        Screen screen = event.getScreen();
        if (InputEventHandler.isContainerTextFieldFocused(screen) && (handler = this.inputHandler.handleUserInput(screen, input = UserInput.fromEvent((ScreenEvent.KeyboardKeyEvent)event))) != null) {
            event.setCanceled(true);
        }
    }

    public void onKeyboardCharTypedEvent(ScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (!InputEventHandler.isContainerTextFieldFocused(event.getScreen()) && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onKeyboardCharTypedEvent(ScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (InputEventHandler.isContainerTextFieldFocused(event.getScreen()) && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiMouseClickedEvent(ScreenEvent.MouseClickedEvent.Pre event) {
        UserInput input = UserInput.fromEvent((ScreenEvent.MouseClickedEvent)event);
        if (input != null) {
            Screen screen = event.getScreen();
            IUserInputHandler handler = this.inputHandler.handleUserInput(screen, input);
            IUserInputHandler dragHandler = null;
            if (input.isLeftClick()) {
                dragHandler = this.inputHandler.handleDragStart(screen, input);
            }
            if (handler != null || dragHandler != null) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseReleasedEvent(ScreenEvent.MouseReleasedEvent.Pre event) {
        UserInput input = UserInput.fromEvent((ScreenEvent.MouseReleasedEvent)event);
        if (input != null) {
            Screen screen = event.getScreen();
            IUserInputHandler handled = this.inputHandler.handleUserInput(screen, input);
            IUserInputHandler dragHandled = null;
            if (input.isLeftClick()) {
                dragHandled = this.inputHandler.handleDragComplete(screen, input);
            }
            if (handled != null || dragHandled != null) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseScrollEvent(ScreenEvent.MouseScrollEvent.Pre event) {
        if (this.inputHandler.handleMouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.charTypedHandlers.stream().filter(ICharTypedHandler::hasKeyboardFocus).anyMatch(handler -> handler.onCharTyped(codePoint, modifiers));
    }

    private static boolean isContainerTextFieldFocused(Screen screen) {
        EditBox textField = ReflectionUtil.getFieldWithClass(screen, EditBox.class);
        return textField != null && textField.isActive() && textField.isFocused();
    }
}

