/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.input.TextHistory;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final IIngredientGridSource ingredientSource;
    private final DrawableNineSliceTexture background;
    private boolean previousKeyboardRepeatEnabled;
    private boolean isDrawing = false;

    public GuiTextFieldFilter(IIngredientGridSource ingredientSource) {
        super(Minecraft.getInstance().font, 0, 0, 0, 0, TextComponent.EMPTY);
        this.setMaxLength(128);
        this.hoverChecker = new HoverChecker();
        this.ingredientSource = ingredientSource;
        this.background = Internal.getTextures().getSearchBackground();
    }

    public void updateBounds(Rect2i area) {
        this.x = area.getX();
        this.y = area.getY();
        this.width = area.getWidth();
        this.height = area.getHeight();
        this.hoverChecker.updateBounds(area.getY(), area.getY() + area.getHeight(), area.getX(), area.getX() + area.getWidth());
        this.setHighlightPos(this.getCursorPosition());
    }

    public void setValue(String filterText) {
        List<IIngredientListElement<?>> ingredientList;
        if (!filterText.equals(this.getValue())) {
            super.setValue(filterText);
        }
        if ((ingredientList = this.ingredientSource.getIngredientList(filterText)).size() == 0) {
            this.setTextColor(-65536);
        } else {
            this.setTextColor(-1);
        }
    }

    private boolean navigateHistory(UserInput userInput) {
        String currentText = this.getValue();
        String newText = null;
        if (userInput.is(KeyBindings.previousSearch)) {
            newText = history.getPrevious(currentText);
        } else if (userInput.is(KeyBindings.nextSearch)) {
            newText = history.getNext(currentText);
        }
        if (newText != null) {
            if (!userInput.isSimulate()) {
                this.setValue(newText);
            }
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    public void setFocused(boolean keyboardFocus) {
        boolean previousFocus = this.isFocused();
        super.setFocused(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.getInstance();
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = minecraft.keyboardHandler.sendRepeatsToGui;
                minecraft.keyboardHandler.setSendRepeatsToGui(true);
            } else {
                minecraft.keyboardHandler.setSendRepeatsToGui(this.previousKeyboardRepeatEnabled);
            }
            String text = this.getValue();
            history.add(text);
        }
    }

    protected boolean isBordered() {
        if (this.isDrawing) {
            return false;
        }
        return super.isBordered();
    }

    public void renderButton(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isDrawing = true;
        if (this.isVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.x, this.y, this.width, this.height);
        }
        super.renderButton(poseStack, mouseX, mouseY, partialTicks);
        this.isDrawing = false;
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
            if (GuiTextFieldFilter.this.isFocused() && (input.isEscapeKey() || input.isEnterKey())) {
                GuiTextFieldFilter.this.setFocused(false);
                return this;
            }
            if (input.is(KeyBindings.focusSearch)) {
                if (!input.isSimulate()) {
                    GuiTextFieldFilter.this.setFocused(true);
                }
                return this;
            }
            if (GuiTextFieldFilter.this.isMouseOver(input.getMouseX(), input.getMouseY()) && input.is(KeyBindings.hoveredClearSearchBar)) {
                if (!input.isSimulate()) {
                    GuiTextFieldFilter.this.setValue("");
                    GuiTextFieldFilter.this.setFocused(true);
                }
                return this;
            }
            if (input.callVanilla(GuiTextFieldFilter.this::isMouseOver, (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)GuiTextFieldFilter.this).mouseClicked(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)GuiTextFieldFilter.this).keyPressed(arg_0, arg_1, arg_2))) {
                return this;
            }
            if (GuiTextFieldFilter.this.navigateHistory(input)) {
                return this;
            }
            if (GuiTextFieldFilter.this.canConsumeInput() && input.isAllowedChatCharacter()) {
                return this;
            }
            return null;
        }

        @Override
        public void handleMouseClickedOut(InputConstants.Key input) {
            GuiTextFieldFilter.this.setFocused(false);
        }
    }
}

