/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClickedIngredient<V>
implements IClickedIngredient<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final V value;
    @Nullable
    private final Rect2i area;
    private boolean canSetFocusWithMouse;
    private boolean allowsCheating;

    @Nullable
    public static <V> ClickedIngredient<V> create(V value, @Nullable Rect2i area) {
        ErrorUtil.checkNotNull(value, "value");
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value);
        try {
            if (ingredientHelper.isValidIngredient(value)) {
                return new ClickedIngredient<V>(value, area);
            }
            String ingredientInfo = ingredientHelper.getErrorInfo(value);
            LOGGER.error("Clicked invalid ingredient. Ingredient Info: {}", (Object)ingredientInfo);
        }
        catch (RuntimeException e) {
            String ingredientInfo = ingredientHelper.getErrorInfo(value);
            LOGGER.error("Clicked invalid ingredient. Ingredient Info: {}", (Object)ingredientInfo, (Object)e);
        }
        return null;
    }

    private ClickedIngredient(V value, @Nullable Rect2i area) {
        this.value = value;
        this.area = area;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Rect2i getArea() {
        return this.area;
    }

    public void setAllowsCheating() {
        this.allowsCheating = true;
    }

    public void setCanSetFocusWithMouse() {
        this.canSetFocusWithMouse = true;
    }

    @Override
    public ItemStack getCheatItemStack() {
        if (this.allowsCheating) {
            IngredientManager ingredientManager = Internal.getIngredientManager();
            IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(this.value);
            return ingredientHelper.getCheatItemStack(this.value);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.canSetFocusWithMouse;
    }

    public String toString() {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(this.value);
        return MoreObjects.toStringHelper(ClickedIngredient.class).add("value", (Object)ingredientHelper.getUniqueId(this.value, UidContext.Ingredient)).add("area", (Object)this.area).add("allowsCheating", this.allowsCheating).add("canSetFocusWithMouse", this.canSetFocusWithMouse).toString();
    }
}

